/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import com.zx.sms.common.util.StandardCharsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeHeaderParameter;
import org.marre.wap.WspEncodingVersion;

public final class WspUtil {
    private static final Map<String, Integer> wspHeaders_;
    private static final Map<String, Integer> wspContentTypes_;
    private static final Map<String, Integer> wspParameters_;
    private static final Map<String, Integer> wspPushAppTypes_;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_11;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_12;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_13;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_14;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_11;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_12;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_13;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_14;
    private static final int[] PARAMETER_TYPES;

    private WspUtil() {
    }

    public static int getHeaderType(String headerName) {
        Integer headerType = wspHeaders_.get(headerName);
        return headerType != null ? headerType : -1;
    }

    public static int getWellKnownHeaderId(WspEncodingVersion wspEncodingVersion, int headerType) {
        int wellKnownHeaderId;
        switch (wspEncodingVersion) {
            case VERSION_1_1: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_11[headerType];
                break;
            }
            case VERSION_1_2: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_12[headerType];
                break;
            }
            case VERSION_1_3: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_13[headerType];
                break;
            }
            case VERSION_1_4: 
            case VERSION_1_5: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_14[headerType];
                break;
            }
            default: {
                wellKnownHeaderId = -1;
            }
        }
        return wellKnownHeaderId;
    }

    public static int getWellKnownContentTypeId(WspEncodingVersion wspEncodingVersion, String contentType) {
        Integer contentTypeIdInt = wspContentTypes_.get(contentType);
        if (contentTypeIdInt == null) {
            return -1;
        }
        int wellKnownContentTypeId = contentTypeIdInt;
        if (wspEncodingVersion.isWellKnownContentTypeId(wellKnownContentTypeId)) {
            return wellKnownContentTypeId;
        }
        return -1;
    }

    public static int getParameterType(String parameterName) {
        Integer parameterType = wspParameters_.get(parameterName);
        return parameterType != null ? parameterType : -1;
    }

    public static int getWspParameterType(int wellKnownParameterId) {
        return PARAMETER_TYPES[wellKnownParameterId];
    }

    public static int getWellKnownParameterId(WspEncodingVersion wspEncodingVersion, int parameterType) {
        int wellKnownParameterId = -1;
        if (parameterType >= 0) {
            switch (wspEncodingVersion) {
                case VERSION_1_1: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_11[parameterType];
                    break;
                }
                case VERSION_1_2: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_12[parameterType];
                    break;
                }
                case VERSION_1_3: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_13[parameterType];
                    break;
                }
                case VERSION_1_4: 
                case VERSION_1_5: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_14[parameterType];
                    break;
                }
            }
        }
        return wellKnownParameterId;
    }

    public static int getWellKnownPushAppId(String pushApp) {
        Integer pushAppIdInt = wspPushAppTypes_.get(pushApp);
        if (pushAppIdInt == null) {
            return -1;
        }
        return pushAppIdInt;
    }

    public static void writeUint8(OutputStream theOs, int theValue) throws IOException {
        theOs.write(theValue);
    }

    public static void writeUintvar(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 1;
        while (theValue >> 7 * nOctets > 0L) {
            ++nOctets;
        }
        for (int i = nOctets; i > 0; --i) {
            byte octet = (byte)(theValue >> 7 * (i - 1));
            byte byteValue = (byte)(octet & 0x7F);
            if (i > 1) {
                byteValue = (byte)(byteValue | 0xFFFFFF80);
            }
            theOs.write(byteValue);
        }
    }

    public static void writeLongInteger(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 0;
        while (theValue >> 8 * nOctets > 0L) {
            ++nOctets;
        }
        theOs.write((byte)nOctets);
        for (int i = nOctets; i > 0; --i) {
            byte octet = (byte)(theValue >> 8 * (i - 1));
            byte byteValue = (byte)(octet & 0xFFFFFFFF);
            theOs.write(byteValue);
        }
    }

    public static void writeInteger(OutputStream theOs, long theValue) throws IOException {
        if (theValue < 128L) {
            WspUtil.writeShortInteger(theOs, (int)theValue);
        } else {
            WspUtil.writeLongInteger(theOs, theValue);
        }
    }

    public static void writeShortInteger(OutputStream theOs, int theValue) throws IOException {
        theOs.write((byte)(theValue | 0xFFFFFF80));
    }

    public static void writeValueLength(OutputStream theOs, long theValue) throws IOException {
        if (theValue <= 30L) {
            theOs.write((int)theValue);
        } else {
            theOs.write(31);
            WspUtil.writeUintvar(theOs, theValue);
        }
    }

    public static void writeExtensionMedia(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTextString(OutputStream theOs, String theStr) throws IOException {
        byte[] strBytes = theStr.getBytes(StandardCharsets.UTF_8);
        if ((strBytes[0] & 0x80) > 0) {
            theOs.write(127);
        }
        theOs.write(strBytes);
        theOs.write(0);
    }

    public static void writeQuotedString(OutputStream theOs, String theStr) throws IOException {
        theOs.write(34);
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTokenText(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes(StandardCharsets.UTF_8));
        theOs.write(0);
    }

    public static void writeTextValue(OutputStream theOs, String theStr) throws IOException {
        WspUtil.writeQuotedString(theOs, theStr);
    }

    public static void writeContentType(WspEncodingVersion wspEncodingVersion, OutputStream theOs, String theContentType) throws IOException {
        int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentType.toLowerCase());
        if (wellKnownContentType == -1) {
            WspUtil.writeValueLength(theOs, theContentType.length() + 1);
            WspUtil.writeExtensionMedia(theOs, theContentType);
        } else {
            WspUtil.writeShortInteger(theOs, wellKnownContentType);
        }
    }

    public static void writeContentType(WspEncodingVersion wspEncodingVersion, OutputStream theOs, MimeHeader theContentType) throws IOException {
        if (theContentType.getParameters().isEmpty()) {
            WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType.getValue());
        } else {
            String theContentTypeStr = theContentType.getValue();
            int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentTypeStr.toLowerCase());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (wellKnownContentType == -1) {
                WspUtil.writeExtensionMedia(baos, theContentType.getValue());
            } else {
                WspUtil.writeInteger(baos, wellKnownContentType);
            }
            for (MimeHeaderParameter headerParam : theContentType.getParameters()) {
                WspUtil.writeParameter(wspEncodingVersion, baos, headerParam.getName(), headerParam.getValue());
            }
            baos.close();
            WspUtil.writeValueLength(theOs, baos.size());
            theOs.write(baos.toByteArray());
        }
    }

    public static void writeTypedValue(WspEncodingVersion wspEncodingVersion, OutputStream os, int wspParamType, String value) throws IOException {
        switch (wspParamType) {
            case 1: {
                os.write(0);
                break;
            }
            case 2: {
                WspUtil.writeTextValue(os, value);
                break;
            }
            case 3: {
                WspUtil.writeInteger(os, Long.parseLong(value));
                break;
            }
            case 4: {
                Long l = Long.valueOf(value);
                WspUtil.writeLongInteger(os, l);
                break;
            }
            case 5: {
                Integer i = Integer.valueOf(value);
                WspUtil.writeInteger(os, i.intValue());
                break;
            }
            case 6: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 7: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 8: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 9: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 10: {
                WspUtil.writeInteger(os, 106L);
                break;
            }
            case 11: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 12: {
                WspUtil.writeShortInteger(os, Integer.parseInt(value));
                break;
            }
            case 13: {
                WspUtil.writeContentType(wspEncodingVersion, os, value);
                break;
            }
            default: {
                WspUtil.writeTextString(os, value);
            }
        }
    }

    public static void writeParameter(WspEncodingVersion wspEncodingVersion, OutputStream os, String name, String value) throws IOException {
        int parameterType = WspUtil.getParameterType(name);
        int wellKnownParameter = WspUtil.getWellKnownParameterId(wspEncodingVersion, parameterType);
        if (wellKnownParameter == -1) {
            WspUtil.writeTokenText(os, name);
            WspUtil.writeTextString(os, value);
        } else {
            WspUtil.writeInteger(os, wellKnownParameter);
            WspUtil.writeTypedValue(wspEncodingVersion, os, WspUtil.getWspParameterType(wellKnownParameter), value);
        }
    }

    public static String convertMultipartContentType(String ct) {
        if (ct.equalsIgnoreCase("multipart/*")) {
            return "application/vnd.wap.multipart.*";
        }
        if (ct.equalsIgnoreCase("multipart/mixed")) {
            return "application/vnd.wap.multipart.mixed";
        }
        if (ct.equalsIgnoreCase("multipart/form-data")) {
            return "application/vnd.wap.multipart.form-data";
        }
        if (ct.equalsIgnoreCase("multipart/byteranges")) {
            return "application/vnd.wap.multipart.byteranges";
        }
        if (ct.equalsIgnoreCase("multipart/alternative")) {
            return "application/vnd.wap.multipart.alternative";
        }
        if (ct.equalsIgnoreCase("multipart/related")) {
            return "application/vnd.wap.multipart.related";
        }
        return ct;
    }

    static {
        WELL_KNOWN_HEADER_ID_WSP_11 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_HEADER_ID_WSP_12 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_HEADER_ID_WSP_13 = new int[]{0, 59, 60, 3, 4, 5, 6, 7, 61, 9, 10, 11, 12, 13, 14, 15, 62, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 63, 64, 65, 66, 67, -1};
        WELL_KNOWN_HEADER_ID_WSP_14 = new int[]{0, 59, 60, 3, 4, 5, 6, 7, 71, 9, 10, 11, 12, 13, 14, 15, 62, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 69, 47, 48, 49, 50, 51, 52, 53, 54, 68, 56, 57, 58, 63, 64, 65, 66, 67, 70};
        WELL_KNOWN_PARAMETER_ID_WSP_11 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_12 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_13 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_14 = new int[]{0, 1, 2, 3, 23, 24, 7, 8, 9, 25, 26, 27, 28, 14, 29, 16, 17, 18, 19, 20, 21, 22};
        PARAMETER_TYPES = new int[]{6, 10, 7, 3, -1, 9, 9, 11, 12, 13, 9, 9, 9, 9, 5, 9, 1, 12, 2, 4, 4, 4, 3, 2, 2, 2, 2, 2, 2, 2};
        wspHeaders_ = new HashMap<String, Integer>();
        wspHeaders_.put("accept", 0);
        wspHeaders_.put("accept-charset", 1);
        wspHeaders_.put("accept-encoding", 2);
        wspHeaders_.put("accept-language", 3);
        wspHeaders_.put("accept-ranges", 4);
        wspHeaders_.put("age", 5);
        wspHeaders_.put("allow", 6);
        wspHeaders_.put("authorization", 7);
        wspHeaders_.put("cache-control", 8);
        wspHeaders_.put("connection", 9);
        wspHeaders_.put("content-base", 10);
        wspHeaders_.put("content-encoding", 11);
        wspHeaders_.put("content-language", 12);
        wspHeaders_.put("content-length", 13);
        wspHeaders_.put("content-location", 14);
        wspHeaders_.put("content-md5", 15);
        wspHeaders_.put("content-range", 16);
        wspHeaders_.put("content-type", 17);
        wspHeaders_.put("date", 18);
        wspHeaders_.put("etag", 19);
        wspHeaders_.put("expires", 20);
        wspHeaders_.put("from", 21);
        wspHeaders_.put("host", 22);
        wspHeaders_.put("if-modified-since", 23);
        wspHeaders_.put("if-match", 24);
        wspHeaders_.put("if-none-match", 25);
        wspHeaders_.put("if-range", 26);
        wspHeaders_.put("if-unmodified-since", 27);
        wspHeaders_.put("location", 29);
        wspHeaders_.put("last-modified", 28);
        wspHeaders_.put("max-forwards", 30);
        wspHeaders_.put("pragma", 31);
        wspHeaders_.put("proxy-authenticate", 32);
        wspHeaders_.put("proxy-authorization", 33);
        wspHeaders_.put("public", 34);
        wspHeaders_.put("range", 35);
        wspHeaders_.put("referer", 36);
        wspHeaders_.put("retry-after", 37);
        wspHeaders_.put("server", 38);
        wspHeaders_.put("transfer-encoding", 39);
        wspHeaders_.put("upgrade", 40);
        wspHeaders_.put("user-agent", 41);
        wspHeaders_.put("vary", 42);
        wspHeaders_.put("via", 43);
        wspHeaders_.put("warning", 44);
        wspHeaders_.put("www-authenticate", 45);
        wspHeaders_.put("content-disposition", 46);
        wspHeaders_.put("accept", 0);
        wspHeaders_.put("x-wap-application-id", 47);
        wspHeaders_.put("x-wap-content-uri", 48);
        wspHeaders_.put("x-wap-initiator-uri", 49);
        wspHeaders_.put("bearer-indication", 51);
        wspHeaders_.put("accept-application", 50);
        wspHeaders_.put("push-flag", 52);
        wspHeaders_.put("profile", 53);
        wspHeaders_.put("profile-diff", 54);
        wspHeaders_.put("profile-warning", 55);
        wspHeaders_.put("expect", 56);
        wspHeaders_.put("te", 57);
        wspHeaders_.put("trailer", 58);
        wspHeaders_.put("accept-charset", 1);
        wspHeaders_.put("accept-encoding", 2);
        wspHeaders_.put("cache-control", 8);
        wspHeaders_.put("content-range", 16);
        wspHeaders_.put("x-wap-tod", 59);
        wspHeaders_.put("content-id", 60);
        wspHeaders_.put("set-cookie", 61);
        wspHeaders_.put("cookie", 62);
        wspHeaders_.put("encoding-version", 63);
        wspHeaders_.put("profile-warning", 55);
        wspHeaders_.put("content-disposition", 46);
        wspHeaders_.put("x-wap-security", 64);
        wspHeaders_.put("cache-control", 8);
        wspContentTypes_ = new HashMap<String, Integer>();
        wspContentTypes_.put("*/*", 0);
        wspContentTypes_.put("text/*", 1);
        wspContentTypes_.put("text/html", 2);
        wspContentTypes_.put("text/plain", 3);
        wspContentTypes_.put("text/x-hdml", 4);
        wspContentTypes_.put("text/x-ttml", 5);
        wspContentTypes_.put("text/x-vCalendar", 6);
        wspContentTypes_.put("text/x-vCard", 7);
        wspContentTypes_.put("text/vnd.wap.wml", 8);
        wspContentTypes_.put("text/vnd.wap.wmlscript", 9);
        wspContentTypes_.put("text/vnd.wap.wta-event", 10);
        wspContentTypes_.put("multipart/*", 11);
        wspContentTypes_.put("multipart/mixed", 12);
        wspContentTypes_.put("multipart/form-data", 13);
        wspContentTypes_.put("multipart/byteranges", 14);
        wspContentTypes_.put("multipart/alternative", 15);
        wspContentTypes_.put("application/*", 16);
        wspContentTypes_.put("application/java-vm", 17);
        wspContentTypes_.put("application/x-www-form-urlencoded", 18);
        wspContentTypes_.put("application/x-hdmlc", 19);
        wspContentTypes_.put("application/vnd.wap.wmlc", 20);
        wspContentTypes_.put("application/vnd.wap.wmlscriptc", 21);
        wspContentTypes_.put("application/vnd.wap.wta-eventc", 22);
        wspContentTypes_.put("application/vnd.wap.uaprof", 23);
        wspContentTypes_.put("application/vnd.wap.wtls-ca-certificate", 24);
        wspContentTypes_.put("application/vnd.wap.wtls-user-certificate", 25);
        wspContentTypes_.put("application/x-x509-ca-cert", 26);
        wspContentTypes_.put("application/x-x509-user-cert", 27);
        wspContentTypes_.put("image/*", 28);
        wspContentTypes_.put("image/gif", 29);
        wspContentTypes_.put("image/jpeg", 30);
        wspContentTypes_.put("image/tiff", 31);
        wspContentTypes_.put("image/png", 32);
        wspContentTypes_.put("image/vnd.wap.wbmp", 33);
        wspContentTypes_.put("application/vnd.wap.multipart.*", 34);
        wspContentTypes_.put("application/vnd.wap.multipart.mixed", 35);
        wspContentTypes_.put("application/vnd.wap.multipart.form-data", 36);
        wspContentTypes_.put("application/vnd.wap.multipart.byteranges", 37);
        wspContentTypes_.put("application/vnd.wap.multipart.alternative", 38);
        wspContentTypes_.put("application/xml", 39);
        wspContentTypes_.put("text/xml", 40);
        wspContentTypes_.put("application/vnd.wap.wbxml", 41);
        wspContentTypes_.put("application/x-x968-cross-cert", 42);
        wspContentTypes_.put("application/x-x968-ca-cert", 43);
        wspContentTypes_.put("application/x-x968-user-cert", 44);
        wspContentTypes_.put("text/vnd.wap.si", 45);
        wspContentTypes_.put("application/vnd.wap.sic", 46);
        wspContentTypes_.put("text/vnd.wap.sl", 47);
        wspContentTypes_.put("application/vnd.wap.slc", 48);
        wspContentTypes_.put("text/vnd.wap.co", 49);
        wspContentTypes_.put("application/vnd.wap.coc", 50);
        wspContentTypes_.put("application/vnd.wap.multipart.related", 51);
        wspContentTypes_.put("application/vnd.wap.sia", 52);
        wspContentTypes_.put("text/vnd.wap.connectivity-xml", 53);
        wspContentTypes_.put("application/vnd.wap.connectivity-wbxml", 54);
        wspContentTypes_.put("application/pkcs7-mime", 55);
        wspContentTypes_.put("application/vnd.wap.hashed-certificate", 56);
        wspContentTypes_.put("application/vnd.wap.signed-certificate", 57);
        wspContentTypes_.put("application/vnd.wap.cert-response", 58);
        wspContentTypes_.put("application/xhtml+xml", 59);
        wspContentTypes_.put("application/wml+xml", 60);
        wspContentTypes_.put("text/css", 61);
        wspContentTypes_.put("application/vnd.wap.mms-message", 62);
        wspContentTypes_.put("application/vnd.wap.rollover-certificate", 63);
        wspContentTypes_.put("application/vnd.wap.locc+wbxml", 64);
        wspContentTypes_.put("application/vnd.wap.loc+xml", 65);
        wspContentTypes_.put("application/vnd.syncml.dm+wbxml", 66);
        wspContentTypes_.put("application/vnd.syncml.dm+xml", 67);
        wspContentTypes_.put("application/vnd.syncml.notification", 68);
        wspContentTypes_.put("application/vnd.wap.xhtml+xml", 69);
        wspContentTypes_.put("application/vnd.wv.csp.cir", 70);
        wspContentTypes_.put("application/vnd.oma.dd+xml", 71);
        wspContentTypes_.put("application/vnd.oma.drm.message", 72);
        wspContentTypes_.put("application/vnd.oma.drm.content", 73);
        wspContentTypes_.put("application/vnd.oma.drm.rights+xml", 74);
        wspContentTypes_.put("application/vnd.oma.drm.rights+wbxml", 75);
        wspParameters_ = new HashMap<String, Integer>();
        wspParameters_.put("q", 0);
        wspParameters_.put("charset", 1);
        wspParameters_.put("level", 2);
        wspParameters_.put("type", 3);
        wspParameters_.put("name", 4);
        wspParameters_.put("filename", 5);
        wspParameters_.put("differences", 6);
        wspParameters_.put("padding", 7);
        wspParameters_.put("type", 8);
        wspParameters_.put("start", 9);
        wspParameters_.put("start-info", 10);
        wspParameters_.put("comment", 11);
        wspParameters_.put("domain", 12);
        wspParameters_.put("max-age", 13);
        wspParameters_.put("path", 14);
        wspParameters_.put("secure", 15);
        wspParameters_.put("sec", 16);
        wspParameters_.put("mac", 17);
        wspParameters_.put("creation-date", 18);
        wspParameters_.put("modification-date", 19);
        wspParameters_.put("read-date", 20);
        wspParameters_.put("size", 21);
        wspParameters_.put("name", 4);
        wspParameters_.put("filename", 5);
        wspParameters_.put("start", 9);
        wspParameters_.put("start-info", 10);
        wspParameters_.put("comment", 11);
        wspParameters_.put("domain", 12);
        wspParameters_.put("path", 14);
        wspPushAppTypes_ = new HashMap<String, Integer>();
        wspPushAppTypes_.put("x-wap-application:*", 0);
        wspPushAppTypes_.put("x-wap-application:push.sia", 1);
        wspPushAppTypes_.put("x-wap-application:wml.ua", 2);
        wspPushAppTypes_.put("x-wap-application:wta.ua", 3);
        wspPushAppTypes_.put("x-wap-application:mms.ua", 4);
        wspPushAppTypes_.put("x-wap-application:push.syncml", 5);
        wspPushAppTypes_.put("x-wap-application:loc.ua", 6);
        wspPushAppTypes_.put("x-wap-application:syncml.dm", 7);
        wspPushAppTypes_.put("x-wap-application:drm.ua", 8);
        wspPushAppTypes_.put("x-wap-application:emn.ua", 9);
        wspPushAppTypes_.put("x-wap-application:wv.ua", 10);
        wspPushAppTypes_.put("x-wap-microsoft:localcontent.ua", 32768);
        wspPushAppTypes_.put("x-wap-microsoft:imclient.ua ", 32769);
        wspPushAppTypes_.put("x-wap-docomo:imode.mail.ua ", 32770);
        wspPushAppTypes_.put("x-wap-docomo:imode.mr.ua", 32771);
        wspPushAppTypes_.put("x-wap-docomo:imode.mf.ua", 32772);
        wspPushAppTypes_.put("x-motorola:location.ua ", 32773);
        wspPushAppTypes_.put("x-motorola:now.ua", 32774);
        wspPushAppTypes_.put("x-motorola:otaprov.ua", 32775);
        wspPushAppTypes_.put("x-motorola:browser.ua", 32776);
        wspPushAppTypes_.put("x-motorola:splash.ua", 32777);
        wspPushAppTypes_.put("x-wap-nai:mvsw.command ", 32779);
        wspPushAppTypes_.put("x-wap-openwave:iota.ua", 32784);
    }
}

