/*
 * Decompiled with CFR 0.152.
 */
package org.marre.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.marre.xml.XmlAttribute;
import org.marre.xml.XmlWriter;

public class TextXmlWriter
implements XmlWriter {
    private final Writer writer_;
    private final Deque<String> tagStack_ = new ArrayDeque<String>();
    protected boolean charsAddedBetweenTags_ = true;

    public TextXmlWriter(Writer writer) {
        this.writer_ = writer;
    }

    @Override
    public void setDoctype(String publicID) {
    }

    @Override
    public void setDoctype(String name, String systemURI) {
    }

    @Override
    public void setDoctype(String name, String publicID, String publicURI) {
    }

    @Override
    public void addStartElement(String tag) throws IOException {
        if (!this.charsAddedBetweenTags_) {
            this.writer_.write("\r\n");
        }
        this.charsAddedBetweenTags_ = false;
        this.writer_.write("<" + tag + ">");
        this.tagStack_.push(tag);
    }

    @Override
    public void addStartElement(String tag, XmlAttribute[] attribs) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public void addEmptyElement(String tag) throws IOException {
        if (!this.charsAddedBetweenTags_) {
            this.writer_.write("\r\n");
        }
        this.charsAddedBetweenTags_ = false;
        this.writer_.write("<" + tag + "/>\r\n");
    }

    @Override
    public void addEmptyElement(String tag, XmlAttribute[] attribs) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public void addEndElement() throws IOException {
        String tag = this.tagStack_.pop();
        this.writer_.write("</" + tag + ">\r\n");
    }

    @Override
    public void addCharacters(char[] ch, int start, int length) throws IOException {
        this.charsAddedBetweenTags_ = true;
        this.writer_.write(ch, start, length);
    }

    @Override
    public void addCharacters(String str) throws IOException {
        this.charsAddedBetweenTags_ = true;
        this.writer_.write(str);
    }

    @Override
    public void flush() throws IOException {
        this.writer_.flush();
    }
}

