/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.GenericSearchRequest;
import com.couchbase.client.core.msg.search.GenericSearchResponse;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AsyncSearchIndexManager {
    private final Core core;
    private final CoreEnvironment environment;

    public AsyncSearchIndexManager(Core core) {
        this.core = core;
        this.environment = core.context().environment();
    }

    private static String indexesPath() {
        return "/api/index";
    }

    private static String indexPath(String indexName) {
        return AsyncSearchIndexManager.indexesPath() + "/" + UrlQueryStringBuilder.urlEncode((String)indexName);
    }

    private static String indexCountPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/count";
    }

    private static String analyzeDocumentPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/analyzeDoc";
    }

    private static String pauseIngestPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/ingestControl/pause";
    }

    private static String resumeIngestPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/ingestControl/resume";
    }

    private static String allowQueryingPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/queryControl/allow";
    }

    private static String disallowQueryingPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/queryControl/disallow";
    }

    private static String freezePlanPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/planFreezeControl/freeze";
    }

    private static String unfreezePlanPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/planFreezeControl/unfreeze";
    }

    public CompletableFuture<SearchIndex> getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public CompletableFuture<SearchIndex> getIndex(String name, GetSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        GetSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_get_index", built.parentSpan().orElse(null));
        return ((CompletableFuture)this.getAllIndexes((GetAllSearchIndexesOptions)GetAllSearchIndexesOptions.getAllSearchIndexesOptions().parentSpan(span)).thenApply(indexes -> {
            Optional<SearchIndex> found = indexes.stream().filter(i -> i.name().equals(name)).findFirst();
            if (found.isPresent()) {
                return found.get();
            }
            throw new IndexNotFoundException(name);
        })).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes(GetAllSearchIndexesOptions options) {
        GetAllSearchIndexesOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_get_all_indexes", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncSearchIndexManager.indexesPath(), span, null).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree((byte[])response.content());
            JsonNode indexDefs = rootNode.get("indexDefs").get("indexDefs");
            Map indexes = (Map)Mapper.convertValue((Object)indexDefs, (TypeReference)new TypeReference<Map<String, SearchIndex>>(){});
            return new ArrayList(indexes.values());
        });
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        GetIndexedSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_get_indexed_documents_count", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.GET, AsyncSearchIndexManager.indexCountPath(name), span, name).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree((byte[])response.content());
            return rootNode.get("count").asLong();
        });
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index) {
        return this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        Validators.notNull((Object)index, (String)"Search Index");
        UpsertSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_upsert_index", built.parentSpan().orElse(null));
        return this.sendRequest(() -> {
            ByteBuf payload = Unpooled.wrappedBuffer((byte[])index.toJson().getBytes(StandardCharsets.UTF_8));
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, AsyncSearchIndexManager.indexPath(index.name()), payload);
            request.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)payload.readableBytes());
            return request;
        }, false, span, index.name(), AsyncSearchIndexManager.indexPath(index.name())).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropIndex(String name) {
        return this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String name, DropSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        DropSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_drop_index", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.DELETE, AsyncSearchIndexManager.indexPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        Validators.notNull((Object)document, (String)"Document");
        AnalyzeDocumentOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_analyze_document", built.parentSpan().orElse(null));
        return ((CompletableFuture)this.sendRequest(() -> {
            ByteBuf content = Unpooled.wrappedBuffer((byte[])Mapper.encodeAsBytes(document.toMap()));
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, AsyncSearchIndexManager.analyzeDocumentPath(name), content);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
            return request;
        }, true, span, name, AsyncSearchIndexManager.analyzeDocumentPath(name)).exceptionally(throwable -> {
            if (throwable.getMessage().contains("Page not found")) {
                throw new FeatureNotAvailableException("Document analysis is not available on this server version!");
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CouchbaseException("Failed to analyze search document", throwable);
        })).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree((byte[])response.content());
            List analyzed = (List)Mapper.convertValue((Object)rootNode.get("analyzed"), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            return analyzed.stream().filter(Objects::nonNull).map(JsonObject::from).collect(Collectors.toList());
        });
    }

    public CompletableFuture<Void> pauseIngest(String name) {
        return this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        PauseIngestSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_pause_ingest", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.pauseIngestPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<Void> resumeIngest(String name) {
        return this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        ResumeIngestSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_resume_ingest", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.resumeIngestPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<Void> allowQuerying(String name) {
        return this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        AllowQueryingSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_allow_querying", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.allowQueryingPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<Void> disallowQuerying(String name) {
        return this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        DisallowQueryingSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_disallow_querying", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.disallowQueryingPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<Void> freezePlan(String name) {
        return this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> freezePlan(String name, FreezePlanSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        FreezePlanSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_freeze_plan", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.freezePlanPath(name), span, name).thenApply(response -> null);
    }

    public CompletableFuture<Void> unfreezePlan(String name) {
        return this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Search Index Name");
        UnfreezePlanSearchIndexOptions.Built built = options.build();
        RequestSpan span = this.buildSpan("manager_search_unfreeze_plan", built.parentSpan().orElse(null));
        return this.sendRequest(HttpMethod.POST, AsyncSearchIndexManager.unfreezePlanPath(name), span, name).thenApply(response -> null);
    }

    private CompletableFuture<GenericSearchResponse> sendRequest(HttpMethod method, String path, RequestSpan span, String indexName) {
        return this.sendRequest(() -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), method == HttpMethod.GET, span, indexName, path);
    }

    private CompletableFuture<GenericSearchResponse> sendRequest(Supplier<FullHttpRequest> httpRequest, boolean idempotent, RequestSpan span, String indexName, String path) {
        GenericSearchRequest request = new GenericSearchRequest(this.environment.timeoutConfig().managementTimeout(), this.core.context(), this.environment.retryStrategy(), httpRequest, idempotent, span, indexName, path);
        return this.sendRequest(request).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    private CompletableFuture<GenericSearchResponse> sendRequest(GenericSearchRequest request) {
        this.core.send((Request)request);
        return request.response();
    }

    private RequestSpan buildSpan(String spanName, RequestSpan parent) {
        RequestSpan span = this.core.context().environment().requestTracer().requestSpan(spanName, parent);
        span.setAttribute("db.system", "couchbase");
        return span;
    }
}

