/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.config;

import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.log.JobEventLogConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JobCoreConfiguration {
    private final String jobName;
    private final String cron;
    private final int shardingTotalCount;
    private final String shardingItemParameters;
    private final String jobParameter;
    private final boolean failover;
    private final boolean misfire;
    private final String description;
    private final JobProperties jobProperties;
    private final Map<String, JobEventConfiguration> jobEventConfigs;

    public static Builder newBuilder(String jobName, String cron, int shardingTotalCount) {
        return new Builder(jobName, cron, shardingTotalCount);
    }

    private JobCoreConfiguration(String jobName, String cron, int shardingTotalCount, String shardingItemParameters, String jobParameter, boolean failover, boolean misfire, String description, JobProperties jobProperties, Map<String, JobEventConfiguration> jobEventConfigs) {
        this.jobName = jobName;
        this.cron = cron;
        this.shardingTotalCount = shardingTotalCount;
        this.shardingItemParameters = shardingItemParameters;
        this.jobParameter = jobParameter;
        this.failover = failover;
        this.misfire = misfire;
        this.description = description;
        this.jobProperties = jobProperties;
        this.jobEventConfigs = jobEventConfigs;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCron() {
        return this.cron;
    }

    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    public String getJobParameter() {
        return this.jobParameter;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public boolean isMisfire() {
        return this.misfire;
    }

    public String getDescription() {
        return this.description;
    }

    public JobProperties getJobProperties() {
        return this.jobProperties;
    }

    public Map<String, JobEventConfiguration> getJobEventConfigs() {
        return this.jobEventConfigs;
    }

    public static class Builder {
        private final String jobName;
        private final String cron;
        private final int shardingTotalCount;
        private String shardingItemParameters = "";
        private String jobParameter = "";
        private boolean failover;
        private boolean misfire = true;
        private String description = "";
        private final JobProperties jobProperties = new JobProperties();
        private final Map<String, JobEventConfiguration> jobEventConfigs = new LinkedHashMap<String, JobEventConfiguration>(2, 1.0f);

        public Builder shardingItemParameters(String shardingItemParameters) {
            if (null != shardingItemParameters) {
                this.shardingItemParameters = shardingItemParameters;
            }
            return this;
        }

        public Builder jobParameter(String jobParameter) {
            if (null != jobParameter) {
                this.jobParameter = jobParameter;
            }
            return this;
        }

        public Builder failover(boolean failover) {
            this.failover = failover;
            return this;
        }

        public Builder misfire(boolean misfire) {
            this.misfire = misfire;
            return this;
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder jobProperties(String key, String value) {
            this.jobProperties.put(key, value);
            return this;
        }

        public Builder jobEventConfiguration(JobEventConfiguration ... jobEventConfigs) {
            if (null == jobEventConfigs) {
                return this;
            }
            for (JobEventConfiguration each : jobEventConfigs) {
                this.jobEventConfigs.put(each.getIdentity(), each);
            }
            return this;
        }

        public final JobCoreConfiguration build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.jobName) ? 1 : 0) != 0, (Object)"jobName can not be empty.");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.cron) ? 1 : 0) != 0, (Object)"cron can not be empty.");
            Preconditions.checkArgument((this.shardingTotalCount > 0 ? 1 : 0) != 0, (Object)"shardingTotalCount should larger than zero.");
            if (this.jobEventConfigs.isEmpty()) {
                JobEventLogConfiguration jobLogEventConfig = new JobEventLogConfiguration();
                this.jobEventConfigs.put(jobLogEventConfig.getIdentity(), jobLogEventConfig);
            }
            return new JobCoreConfiguration(this.jobName, this.cron, this.shardingTotalCount, this.shardingItemParameters, this.jobParameter, this.failover, this.misfire, this.description, this.jobProperties, this.jobEventConfigs);
        }

        private Builder(String jobName, String cron, int shardingTotalCount) {
            this.jobName = jobName;
            this.cron = cron;
            this.shardingTotalCount = shardingTotalCount;
        }
    }
}

