/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.log;

import com.dangdang.ddframe.job.event.JobEventListener;
import com.dangdang.ddframe.job.event.JobExecutionEvent;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.event.log.JobEventLogIdentity;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobEventLogListener
extends JobEventLogIdentity
implements JobEventListener {
    private static final Logger log = LoggerFactory.getLogger(JobEventLogListener.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd hh:mm:ss.SSSS";

    @Override
    public void listen(JobTraceEvent traceEvent) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        String msg = "Elastic-Job tracing => jobName: '{}', hostname: '{}', message: '{}', failureCause: '{}', creationTime: '{}'";
        switch (traceEvent.getLogLevel()) {
            case TRACE: {
                log.trace(msg, new Object[]{traceEvent.getJobName(), traceEvent.getHostname(), traceEvent.getMessage(), traceEvent.getFailureCause(), format.format(traceEvent.getCreationTime())});
                break;
            }
            case DEBUG: {
                log.debug(msg, new Object[]{traceEvent.getJobName(), traceEvent.getHostname(), traceEvent.getMessage(), traceEvent.getFailureCause(), format.format(traceEvent.getCreationTime())});
                break;
            }
            case INFO: {
                log.info(msg, new Object[]{traceEvent.getJobName(), traceEvent.getHostname(), traceEvent.getMessage(), traceEvent.getFailureCause(), format.format(traceEvent.getCreationTime())});
                break;
            }
            case WARN: {
                log.warn(msg, new Object[]{traceEvent.getJobName(), traceEvent.getHostname(), traceEvent.getMessage(), traceEvent.getFailureCause(), format.format(traceEvent.getCreationTime())});
                break;
            }
            case ERROR: {
                log.error(msg, new Object[]{traceEvent.getJobName(), traceEvent.getHostname(), traceEvent.getMessage(), traceEvent.getFailureCause(), format.format(traceEvent.getCreationTime())});
                break;
            }
        }
    }

    @Override
    public void listen(JobExecutionEvent jobExecutionEvent) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        if (null == jobExecutionEvent.getCompleteTime()) {
            String msg = "Elastic-Job execution start => jobName: '{}', hostname: '{}', shardingItem: '{}', executionSource: '{}', startTime: '{}'";
            log.debug(msg, new Object[]{jobExecutionEvent.getJobName(), jobExecutionEvent.getHostname(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource(), format.format(jobExecutionEvent.getStartTime())});
            return;
        }
        if (jobExecutionEvent.isSuccess()) {
            String msg = "Elastic-Job execution success => jobName: '{}', hostname: '{}', shardingItem: '{}', executionSource: '{}', startTime: '{}', completeTime: '{}'";
            log.debug(msg, new Object[]{jobExecutionEvent.getJobName(), jobExecutionEvent.getHostname(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource(), format.format(jobExecutionEvent.getStartTime()), format.format(jobExecutionEvent.getCompleteTime())});
            return;
        }
        String msg = "Elastic-Job execution failure => jobName: '{}', hostname: '{}', shardingItem: '{}', executionSource: '{}', startTime: '{}', completeTime: '{}', failureCause: '{}'";
        log.error(msg, new Object[]{jobExecutionEvent.getJobName(), jobExecutionEvent.getHostname(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource(), format.format(jobExecutionEvent.getStartTime()), format.format(jobExecutionEvent.getCompleteTime()), jobExecutionEvent.getFailureCause()});
    }
}

