/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.rdb;

import com.dangdang.ddframe.job.event.JobExecutionEvent;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbDataSourceFactory;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobEventRdbStorage {
    private static final Logger log = LoggerFactory.getLogger(JobEventRdbStorage.class);
    private final DataSource dataSource;
    private final JobTraceEvent.LogLevel logLevel;

    JobEventRdbStorage(String driverClassName, String url, String username, String password, JobTraceEvent.LogLevel logLevel) throws SQLException {
        this.logLevel = logLevel;
        this.dataSource = JobEventRdbDataSourceFactory.getDataSource(driverClassName, url, username, password);
        this.createJobExecutionTable();
        this.createJobTraceTable();
    }

    boolean addJobTraceEvent(JobTraceEvent traceEvent) {
        boolean result = false;
        if (this.needTrace(traceEvent.getLogLevel())) {
            String sql = "INSERT INTO `JOB_TRACE_LOG` (`id`, `job_name`, `hostname`, `ip`, `log_level`, `message`, `failure_cause`, `creation_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?);";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setString(1, UUID.randomUUID().toString());
                preparedStatement.setString(2, traceEvent.getJobName());
                preparedStatement.setString(3, traceEvent.getHostname());
                preparedStatement.setString(4, traceEvent.getIp());
                preparedStatement.setString(5, traceEvent.getLogLevel().name());
                preparedStatement.setString(6, traceEvent.getMessage());
                preparedStatement.setString(7, this.truncateFailureCause(traceEvent.getFailureCause()));
                preparedStatement.setTimestamp(8, new Timestamp(traceEvent.getCreationTime().getTime()));
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        }
        return result;
    }

    boolean addJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        if (null == jobExecutionEvent.getCompleteTime()) {
            String sql = "INSERT INTO `JOB_EXECUTION_LOG` (`id`, `job_name`, `hostname`, `ip`, `sharding_item`, `execution_source`, `is_success`, `start_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?);";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setString(1, jobExecutionEvent.getId());
                preparedStatement.setString(2, jobExecutionEvent.getJobName());
                preparedStatement.setString(3, jobExecutionEvent.getHostname());
                preparedStatement.setString(4, jobExecutionEvent.getIp());
                preparedStatement.setInt(5, jobExecutionEvent.getShardingItem());
                preparedStatement.setString(6, jobExecutionEvent.getSource().toString());
                preparedStatement.setBoolean(7, jobExecutionEvent.isSuccess());
                preparedStatement.setTimestamp(8, new Timestamp(jobExecutionEvent.getStartTime().getTime()));
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        } else if (jobExecutionEvent.isSuccess()) {
            String sql = "UPDATE `JOB_EXECUTION_LOG` SET `is_success` = ?, `complete_time` = ? WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
                preparedStatement.setTimestamp(2, new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
                preparedStatement.setString(3, jobExecutionEvent.getId());
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        } else {
            String sql = "UPDATE `JOB_EXECUTION_LOG` SET `is_success` = ?, `failure_cause` = ? WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
                preparedStatement.setString(2, this.truncateFailureCause(jobExecutionEvent.getFailureCause()));
                preparedStatement.setString(3, jobExecutionEvent.getId());
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        }
        return result;
    }

    private boolean needTrace(JobTraceEvent.LogLevel logLevel) {
        return logLevel.ordinal() >= this.logLevel.ordinal();
    }

    private String truncateFailureCause(String failureCause) {
        return !Strings.isNullOrEmpty((String)failureCause) && failureCause.length() > 4000 ? failureCause.substring(0, 4000) : failureCause;
    }

    private void createJobTraceTable() throws SQLException {
        String dbSchema = "CREATE TABLE IF NOT EXISTS `JOB_TRACE_LOG` (`id` VARCHAR(40) NOT NULL, `job_name` VARCHAR(100) NOT NULL, `hostname` VARCHAR(255) NOT NULL, `ip` VARCHAR(50) NOT NULL, `log_level` CHAR(5) NOT NULL, `message` VARCHAR(2000) NOT NULL, `failure_cause` VARCHAR(4000) NULL, `creation_time` TIMESTAMP NOT NULL, PRIMARY KEY (`id`));";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(dbSchema);){
            preparedStatement.execute();
        }
    }

    private void createJobExecutionTable() throws SQLException {
        String dbSchema = "CREATE TABLE IF NOT EXISTS `JOB_EXECUTION_LOG` (`id` VARCHAR(40) NOT NULL, `job_name` VARCHAR(100) NOT NULL, `hostname` VARCHAR(255) NOT NULL, `ip` VARCHAR(50) NOT NULL, `sharding_item` INT NOT NULL, `execution_source` VARCHAR(20) NOT NULL, `failure_cause` VARCHAR(4000) NULL, `is_success` BIT NOT NULL, `start_time` TIMESTAMP NOT NULL, `complete_time` TIMESTAMP NULL, PRIMARY KEY (`id`));";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(dbSchema);){
            preparedStatement.execute();
        }
    }
}

