/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.util.json;

import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobRootConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.dataflow.DataflowJobConfiguration;
import com.dangdang.ddframe.job.config.script.ScriptJobConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.event.log.JobEventLogConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.util.json.GsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJobConfigurationGsonTypeAdapter<T extends JobRootConfiguration>
extends TypeAdapter<T> {
    public T read(JsonReader in) throws IOException {
        boolean failover;
        String jobName = "";
        String cron = "";
        int shardingTotalCount = 0;
        String shardingItemParameters = "";
        String jobParameter = "";
        boolean misfire = failover = false;
        String description = "";
        JobProperties jobProperties = new JobProperties();
        JobEventConfiguration[] jobEventConfigs = null;
        JobType jobType = null;
        String jobClass = "";
        boolean streamingProcess = false;
        String scriptCommandLine = "";
        HashMap<String, Object> customizedValueMap = new HashMap<String, Object>(32, 1.0f);
        in.beginObject();
        block32: while (in.hasNext()) {
            String jsonName;
            switch (jsonName = in.nextName()) {
                case "jobName": {
                    jobName = in.nextString();
                    continue block32;
                }
                case "cron": {
                    cron = in.nextString();
                    continue block32;
                }
                case "shardingTotalCount": {
                    shardingTotalCount = in.nextInt();
                    continue block32;
                }
                case "shardingItemParameters": {
                    shardingItemParameters = in.nextString();
                    continue block32;
                }
                case "jobParameter": {
                    jobParameter = in.nextString();
                    continue block32;
                }
                case "failover": {
                    failover = in.nextBoolean();
                    continue block32;
                }
                case "misfire": {
                    misfire = in.nextBoolean();
                    continue block32;
                }
                case "description": {
                    description = in.nextString();
                    continue block32;
                }
                case "jobProperties": {
                    jobProperties = this.getJobProperties(in);
                    continue block32;
                }
                case "jobEventConfigs": {
                    jobEventConfigs = this.getJobEventConfigs(in);
                    continue block32;
                }
                case "jobType": {
                    jobType = JobType.valueOf(in.nextString());
                    continue block32;
                }
                case "jobClass": {
                    jobClass = in.nextString();
                    continue block32;
                }
                case "streamingProcess": {
                    streamingProcess = in.nextBoolean();
                    continue block32;
                }
                case "scriptCommandLine": {
                    scriptCommandLine = in.nextString();
                    continue block32;
                }
            }
            this.addToCustomizedValueMap(jsonName, in, customizedValueMap);
        }
        in.endObject();
        JobCoreConfiguration coreConfig = this.getJobCoreConfiguration(jobName, cron, shardingTotalCount, shardingItemParameters, jobParameter, failover, misfire, description, jobProperties, jobEventConfigs);
        JobTypeConfiguration typeConfig = this.getJobTypeConfiguration(coreConfig, jobType, jobClass, streamingProcess, scriptCommandLine);
        return this.getJobRootConfiguration(typeConfig, customizedValueMap);
    }

    private JobProperties getJobProperties(JsonReader in) throws IOException {
        JobProperties result = new JobProperties();
        in.beginObject();
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "job_exception_handler": {
                    result.put(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), in.nextString());
                    break;
                }
                case "executor_service_handler": {
                    result.put(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), in.nextString());
                    break;
                }
            }
        }
        in.endObject();
        return result;
    }

    private JobEventConfiguration[] getJobEventConfigs(JsonReader in) throws IOException {
        ArrayList<JobEventConfiguration> result = new ArrayList<JobEventConfiguration>(2);
        in.beginObject();
        while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "log": {
                    in.beginObject();
                    result.add(new JobEventLogConfiguration());
                    in.endObject();
                    break;
                }
                case "rdb": {
                    String url = "";
                    String username = "";
                    String password = "";
                    String driverClassName = "";
                    String logLevel = "";
                    in.beginObject();
                    while (in.hasNext()) {
                        switch (in.nextName()) {
                            case "url": {
                                url = in.nextString();
                                break;
                            }
                            case "username": {
                                username = in.nextString();
                                break;
                            }
                            case "password": {
                                password = in.nextString();
                                break;
                            }
                            case "driverClassName": {
                                driverClassName = in.nextString();
                                break;
                            }
                            case "logLevel": {
                                logLevel = in.nextString();
                                break;
                            }
                        }
                    }
                    in.endObject();
                    result.add(new JobEventRdbConfiguration(driverClassName, url, username, password, JobTraceEvent.LogLevel.valueOf(logLevel.toUpperCase())));
                    break;
                }
            }
        }
        in.endObject();
        return (JobEventConfiguration[])Iterables.toArray(result, JobEventConfiguration.class);
    }

    protected abstract void addToCustomizedValueMap(String var1, JsonReader var2, Map<String, Object> var3) throws IOException;

    private JobCoreConfiguration getJobCoreConfiguration(String jobName, String cron, int shardingTotalCount, String shardingItemParameters, String jobParameter, boolean failover, boolean misfire, String description, JobProperties jobProperties, JobEventConfiguration[] jobEventConfigs) {
        return JobCoreConfiguration.newBuilder(jobName, cron, shardingTotalCount).shardingItemParameters(shardingItemParameters).jobParameter(jobParameter).failover(failover).misfire(misfire).description(description).jobProperties(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), jobProperties.get(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER)).jobProperties(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), jobProperties.get(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER)).jobEventConfiguration(jobEventConfigs).build();
    }

    private JobTypeConfiguration getJobTypeConfiguration(JobCoreConfiguration coreConfig, JobType jobType, String jobClass, boolean streamingProcess, String scriptCommandLine) {
        JobTypeConfiguration result;
        Preconditions.checkNotNull((Object)((Object)jobType), (Object)"jobType cannot be null.");
        switch (jobType) {
            case SIMPLE: {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobClass) ? 1 : 0) != 0, (Object)"jobClass cannot be empty.");
                result = new SimpleJobConfiguration(coreConfig, jobClass);
                break;
            }
            case DATAFLOW: {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobClass) ? 1 : 0) != 0, (Object)"jobClass cannot be empty.");
                result = new DataflowJobConfiguration(coreConfig, jobClass, streamingProcess);
                break;
            }
            case SCRIPT: {
                result = new ScriptJobConfiguration(coreConfig, scriptCommandLine);
                break;
            }
            default: {
                throw new UnsupportedOperationException(jobType.name());
            }
        }
        return result;
    }

    protected abstract T getJobRootConfiguration(JobTypeConfiguration var1, Map<String, Object> var2);

    public void write(JsonWriter out, T value) throws IOException {
        out.beginObject();
        out.name("jobName").value(value.getTypeConfig().getCoreConfig().getJobName());
        out.name("jobClass").value(value.getTypeConfig().getJobClass());
        out.name("jobType").value(value.getTypeConfig().getJobType().name());
        out.name("cron").value(value.getTypeConfig().getCoreConfig().getCron());
        out.name("shardingTotalCount").value((long)value.getTypeConfig().getCoreConfig().getShardingTotalCount());
        out.name("shardingItemParameters").value(value.getTypeConfig().getCoreConfig().getShardingItemParameters());
        out.name("jobParameter").value(value.getTypeConfig().getCoreConfig().getJobParameter());
        out.name("failover").value(value.getTypeConfig().getCoreConfig().isFailover());
        out.name("misfire").value(value.getTypeConfig().getCoreConfig().isMisfire());
        out.name("description").value(value.getTypeConfig().getCoreConfig().getDescription());
        out.name("jobProperties").jsonValue(value.getTypeConfig().getCoreConfig().getJobProperties().json());
        out.name("jobEventConfigs").jsonValue(GsonFactory.getGson().toJson(value.getTypeConfig().getCoreConfig().getJobEventConfigs()));
        if (value.getTypeConfig().getJobType() == JobType.DATAFLOW) {
            DataflowJobConfiguration dataflowJobConfig = (DataflowJobConfiguration)value.getTypeConfig();
            out.name("streamingProcess").value(dataflowJobConfig.isStreamingProcess());
        } else if (value.getTypeConfig().getJobType() == JobType.SCRIPT) {
            ScriptJobConfiguration scriptJobConfig = (ScriptJobConfiguration)value.getTypeConfig();
            out.name("scriptCommandLine").value(scriptJobConfig.getScriptCommandLine());
        }
        this.writeCustomized(out, value);
        out.endObject();
    }

    protected abstract void writeCustomized(JsonWriter var1, T var2) throws IOException;
}

