/*
 * Decompiled with CFR 0.152.
 */
package com.domingosuarez.boot.autoconfigure.jade4j;

import com.domingosuarez.boot.autoconfigure.jade4j.JadeHelper;
import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.spring.template.SpringTemplateLoader;
import de.neuland.jade4j.spring.view.JadeViewResolver;
import de.neuland.jade4j.template.TemplateLoader;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={SpringTemplateLoader.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class Jade4JAutoConfiguration {
    public static final String DEFAULT_PREFIX = "classpath:/templates/";
    public static final String DEFAULT_SUFFIX = ".jade";

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    protected static class Jade4JViewResolverConfiguration
    implements EnvironmentAware {
        private RelaxedPropertyResolver environment;
        @Autowired
        private JadeConfiguration jadeConfiguration;
        @Autowired
        private SpringTemplateLoader templateEngine;

        protected Jade4JViewResolverConfiguration() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.jade4j.");
        }

        @Bean
        @ConditionalOnMissingBean(name={"jade4jViewResolver"})
        public JadeViewResolver jade4jViewResolver() {
            JadeViewResolver resolver = new JadeViewResolver();
            resolver.setConfiguration(this.jadeConfiguration);
            resolver.setContentType(this.appendCharset(this.environment.getProperty("contentType", "text/html"), this.templateEngine.getEncoding()));
            resolver.setViewNames((String[])this.environment.getProperty("viewNames", String[].class));
            resolver.setOrder(((Integer)this.environment.getProperty("resolver.order", Integer.class, (Object)2147483597)).intValue());
            return resolver;
        }

        @Bean
        public BeanPostProcessor jade4jBeanPostProcessor() {
            return new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    JadeHelper annotation = (JadeHelper)AnnotationUtils.findAnnotation(bean.getClass(), JadeHelper.class);
                    if (annotation != null) {
                        Map variables = Jade4JViewResolverConfiguration.this.jadeConfiguration.getSharedVariables();
                        variables.put(beanName, bean);
                        Jade4JViewResolverConfiguration.this.jadeConfiguration.setSharedVariables(variables);
                    }
                    return bean;
                }
            };
        }

        private String appendCharset(String type, String charset) {
            if (type.contains("charset=")) {
                return type;
            }
            return type + ";charset=" + charset;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"defaultSpringTemplateLoader"})
    public static class DefaultTemplateResolverConfiguration
    implements EnvironmentAware {
        @Autowired
        private final ResourceLoader resourceLoader = new DefaultResourceLoader();
        private RelaxedPropertyResolver environment;

        public void setEnvironment(Environment environment) {
            this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.jade4j.");
        }

        @PostConstruct
        public void checkTemplateLocationExists() {
            Boolean checkTemplateLocation = (Boolean)this.environment.getProperty("checkTemplateLocation", Boolean.class, (Object)true);
            if (checkTemplateLocation.booleanValue()) {
                Resource resource = this.resourceLoader.getResource(this.environment.getProperty("prefix", Jade4JAutoConfiguration.DEFAULT_PREFIX));
                Assert.state((boolean)resource.exists(), (String)("Cannot find template location: " + resource + " (please add some templates or check your jade4j configuration)"));
            }
        }

        @Bean
        public SpringTemplateLoader defaultSpringTemplateLoader() {
            SpringTemplateLoader resolver = new SpringTemplateLoader();
            resolver.setBasePath(this.environment.getProperty("prefix", Jade4JAutoConfiguration.DEFAULT_PREFIX));
            resolver.setSuffix(this.environment.getProperty("suffix", Jade4JAutoConfiguration.DEFAULT_SUFFIX));
            resolver.setEncoding(this.environment.getProperty("encoding", "UTF-8"));
            return resolver;
        }

        @Bean
        public JadeConfiguration defaultJadeConfiguration() {
            JadeConfiguration configuration = new JadeConfiguration();
            configuration.setCaching(((Boolean)this.environment.getProperty("caching", Boolean.class, (Object)true)).booleanValue());
            configuration.setTemplateLoader((TemplateLoader)this.defaultSpringTemplateLoader());
            configuration.setPrettyPrint(((Boolean)this.environment.getProperty("prettyPrint", Boolean.class, (Object)false)).booleanValue());
            configuration.setMode((Jade4J.Mode)this.environment.getProperty("mode", Jade4J.Mode.class, (Object)Jade4J.Mode.HTML));
            return configuration;
        }
    }
}

