/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements StringIterator {
    private final int aMaxIndex;
    private final Character[] aStrings;
    private int aIndex = -1;

    public ArrayIterator(Character[] strings) {
        this.aStrings = strings;
        this.aMaxIndex = this.aStrings.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.aIndex < this.aMaxIndex;
    }

    @Override
    public String next() {
        ++this.aIndex;
        if (this.aIndex >= this.aStrings.length) {
            throw new NoSuchElementException("Not enough elements in arrays");
        }
        return this.aStrings[this.aIndex].toString();
    }

    @Override
    public void reset() {
        this.aIndex = -1;
    }

    @Override
    public String current() {
        return this.aStrings[this.aIndex].toString();
    }
}

