/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.ProjectModel;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.github.ferstl.maven.pomenforcers.util.XmlUtils;
import java.io.File;
import javax.xml.bind.JAXB;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;

public abstract class AbstractPedanticEnforcer
implements EnforcerRule2 {
    private EnforcerRuleHelper helper;
    private Document pom;
    private ProjectModel projectModel;
    private boolean warnOnly;

    public final void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = EnforcerRuleUtils.getMavenProject(helper);
        Document pom = XmlUtils.parseXml(project.getFile());
        ProjectModel model = (ProjectModel)JAXB.unmarshal((File)project.getFile(), ProjectModel.class);
        this.initialize(helper, pom, model);
        ErrorReport report = new ErrorReport(this.getDescription());
        this.doEnforce(report);
        if (report.hasErrors()) {
            throw new EnforcerRuleException(report.toString());
        }
    }

    void initialize(EnforcerRuleHelper helper, Document pom, ProjectModel projectModel) {
        this.helper = helper;
        this.pom = pom;
        this.projectModel = projectModel;
    }

    protected EnforcerRuleHelper getHelper() {
        return this.helper;
    }

    protected Document getPom() {
        return this.pom;
    }

    protected ProjectModel getProjectModel() {
        return this.projectModel;
    }

    protected abstract PedanticEnforcerRule getDescription();

    protected abstract void doEnforce(ErrorReport var1);

    protected abstract void accept(PedanticEnforcerVisitor var1);

    public EnforcerLevel getLevel() {
        return this.warnOnly ? EnforcerLevel.WARN : EnforcerLevel.ERROR;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return this.getClass() + "-uncachable";
    }
}

