/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.ArtifactModel;
import com.github.ferstl.maven.pomenforcers.model.functions.StringToArtifactTransformer;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class PedanticDependencyManagementLocationEnforcer
extends AbstractPedanticEnforcer {
    private boolean allowParentPoms = false;
    private final Set<ArtifactModel> dependencyManagingPoms = new HashSet<ArtifactModel>();

    public void setAllowParentPoms(boolean allowParentPoms) {
        this.allowParentPoms = allowParentPoms;
    }

    public void setDependencyManagingPoms(String dependencyManagingPoms) {
        CommaSeparatorUtils.splitAndAddToCollection(dependencyManagingPoms, this.dependencyManagingPoms, StringToArtifactTransformer::toArtifactModel);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_MANAGEMENT_LOCATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        MavenProject mavenProject = EnforcerRuleUtils.getMavenProject(this.getHelper());
        if (this.containsDependencyManagement() && !this.isDependencyManagementAllowed(mavenProject)) {
            report.addLine("Only these POMs are allowed to manage dependencies:").addLine(ErrorReport.toList(Collections.singletonList("All parent POMs, i.e. POMs with <packaging>pom</packaging>"))).addLine(ErrorReport.toList(this.dependencyManagingPoms));
        }
    }

    private boolean containsDependencyManagement() {
        return !this.getProjectModel().getManagedDependencies().isEmpty();
    }

    private boolean isDependencyManagementAllowed(MavenProject project) {
        return this.isDependencyManagementAllowedInParentPom(project) || this.isDependencyManagingProject(project);
    }

    private boolean isDependencyManagementAllowedInParentPom(MavenProject project) {
        return this.allowParentPoms && "pom".equals(project.getPackaging());
    }

    private boolean isDependencyManagingProject(MavenProject project) {
        ArtifactModel projectInfo = new ArtifactModel(project.getGroupId(), project.getArtifactId(), project.getVersion());
        return this.dependencyManagingPoms.isEmpty() || this.dependencyManagingPoms.contains(projectInfo);
    }
}

