/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.util;

import com.google.common.base.Strings;
import difflib.Chunk;
import difflib.Delta;
import difflib.DiffUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class SideBySideDiffUtil {
    public static String diff(Collection<String> actual, Collection<String> required, String leftTitle, String rightTitle) {
        SideBySideContext context = new SideBySideContext(actual, required, leftTitle, rightTitle);
        int offset = 0;
        block5: for (Delta delta : context.deltas) {
            Chunk original = delta.getOriginal();
            Chunk revised = delta.getRevised();
            int currentPosition = original.getPosition() + offset;
            switch (delta.getType()) {
                case INSERT: {
                    offset += context.expand(currentPosition, revised.size());
                    context.setRightContent(currentPosition, revised.getLines());
                    continue block5;
                }
                case CHANGE: {
                    int difference = revised.size() - original.size();
                    if (difference > 0) {
                        offset += context.expand(currentPosition + original.size(), difference);
                    } else {
                        context.clearRightContent(currentPosition + revised.size(), Math.abs(difference));
                    }
                    context.setLeftContent(currentPosition, original.getLines());
                    context.setRightContent(currentPosition, revised.getLines());
                    continue block5;
                }
                case DELETE: {
                    context.setLeftContent(currentPosition, original.getLines());
                    context.clearRightContent(currentPosition, original.size());
                    continue block5;
                }
            }
            throw new IllegalStateException("Unsupported delta type: " + delta.getType());
        }
        return context.toString();
    }

    private SideBySideDiffUtil() {
        throw new AssertionError((Object)"not instantiable");
    }

    private static class SideBySideContext {
        private static final String SIDE_SEPARATOR = " |";
        private static final String EMPTY_MARKER = "  ";
        private static final String DELETION_MARKER = "- ";
        private static final String INSERTION_MARKER = "+ ";
        private final String leftTitle;
        private final String rightTitle;
        private final int leftWidth;
        private final int rightWidth;
        private final Collection<Delta<String>> deltas;
        private final List<String> left;
        private final List<String> right;

        public SideBySideContext(Collection<String> original, Collection<String> revised, String leftTitle, String rightTitle) {
            this.leftTitle = leftTitle;
            this.rightTitle = rightTitle;
            List<Object> originalList = original instanceof List ? (List<Object>)original : new ArrayList<String>(original);
            List<Object> revisedList = revised instanceof List ? (List<Object>)revised : new ArrayList<String>(revised);
            this.deltas = DiffUtils.diff((List)originalList, (List)revisedList).getDeltas();
            this.leftWidth = Math.max(SideBySideContext.getMaxWidth(original) + 2, leftTitle.length());
            this.rightWidth = Math.max(SideBySideContext.getMaxWidth(revised) + 2, rightTitle.length());
            int length = Math.max(original.size(), revised.size());
            this.left = new ArrayList<String>(length += SideBySideContext.getExpansionLength(this.deltas));
            this.right = new ArrayList<String>(length);
            for (String string : original) {
                String line = this.formatLine(EMPTY_MARKER, string);
                this.left.add(line);
                this.right.add(line);
            }
        }

        public void setLeftContent(int index, Collection<String> content) {
            this.setContent(this.left, index, DELETION_MARKER, content);
        }

        public void setRightContent(int index, Collection<String> content) {
            this.setContent(this.right, index, INSERTION_MARKER, content);
        }

        public void clearRightContent(int index, int size) {
            this.clearContent(this.right, index, size);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.shouldPrintTitle()) {
                String leftTitlePadded = Strings.padEnd((String)this.leftTitle, (int)this.leftWidth, (char)' ');
                sb.append(leftTitlePadded).append(SIDE_SEPARATOR).append(" ").append(this.rightTitle).append("\n");
                sb.append(Strings.repeat((String)"-", (int)(this.leftWidth + SIDE_SEPARATOR.length() + this.rightWidth + 1))).append("\n");
            }
            for (int i = 0; i < this.left.size(); ++i) {
                String leftLine = this.left.get(i);
                String rightLine = this.right.get(i);
                String leftPadded = Strings.padEnd((String)leftLine, (int)this.leftWidth, (char)' ');
                sb.append(leftPadded).append(SIDE_SEPARATOR);
                if (!rightLine.isEmpty()) {
                    sb.append(" ").append(rightLine);
                }
                sb.append("\n");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public boolean shouldPrintTitle() {
            return !(this.leftTitle.isEmpty() && this.rightTitle.isEmpty() || this.left.isEmpty() && this.right.isEmpty());
        }

        private static int getMaxWidth(Collection<String> content) {
            int width = 0;
            for (String string : content) {
                width = Math.max(width, string.length());
            }
            return width;
        }

        private static int getExpansionLength(Collection<Delta<String>> deltas) {
            int length = 0;
            for (Delta<String> delta : deltas) {
                switch (delta.getType()) {
                    case INSERT: 
                    case CHANGE: {
                        int expansion = delta.getRevised().size() - delta.getOriginal().size();
                        length += expansion > 0 ? expansion : 0;
                        break;
                    }
                }
            }
            return length;
        }

        private String formatLine(String prefix, String line) {
            return prefix + line;
        }

        private int expand(int index, int size) {
            Object[] emptyLines = new String[size];
            Arrays.fill(emptyLines, "");
            List<Object> emptyLinesAsList = Arrays.asList(emptyLines);
            this.left.addAll(index, emptyLinesAsList);
            this.right.addAll(index, emptyLinesAsList);
            return size;
        }

        private void clearContent(List<String> l, int index, int size) {
            if (size < 1) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                l.set(i + index, "");
            }
        }

        private void setContent(List<String> l, int index, String prefix, Collection<String> lines) {
            int i = 0;
            for (String line : lines) {
                l.set(index + i++, this.formatLine(prefix, line));
            }
        }
    }
}

