/*
 * Decompiled with CFR 0.152.
 */
package com.github.dantwining.whitespace;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class WhitespaceUtils {
    private WhitespaceUtils() {
    }

    public static void detectWhitespace(boolean verify, File searchBaseDirectory, String extensions, Log mavenLog, String encoding) throws MojoExecutionException, MojoFailureException {
        if (!searchBaseDirectory.isDirectory()) {
            mavenLog.debug((CharSequence)("Skipping non-existent directory: " + searchBaseDirectory.getAbsolutePath()));
            return;
        }
        String cleanExtensions = StringUtils.deleteWhitespace((String)extensions);
        mavenLog.info((CharSequence)("Processing the following extensions: " + cleanExtensions));
        Collection matchingFiles = FileUtils.listFiles((File)searchBaseDirectory, (String[])cleanExtensions.split(","), (boolean)true);
        ArrayList<String> verifyFailed = new ArrayList<String>();
        for (File matchingFile : matchingFiles) {
            List<String> lines;
            mavenLog.debug((CharSequence)("Reading file: " + matchingFile.getAbsolutePath()));
            try {
                lines = Files.readAllLines(matchingFile.toPath(), Charset.forName(encoding));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read lines from " + matchingFile.getAbsolutePath(), (Exception)e);
            }
            boolean isFileModified = false;
            ArrayList<String> trimmedLines = new ArrayList<String>(lines.size());
            int lineNumber = 0;
            for (String line : lines) {
                String trimmedLine;
                boolean isLineModified;
                if (mavenLog.isDebugEnabled()) {
                    ++lineNumber;
                }
                boolean bl = isLineModified = !(trimmedLine = StringUtils.stripEnd((String)line, null)).equals(line);
                if (mavenLog.isDebugEnabled() && isLineModified) {
                    mavenLog.debug((CharSequence)("Whitespace found on line " + lineNumber));
                }
                trimmedLines.add(trimmedLine);
                isFileModified = isFileModified || isLineModified;
            }
            if (!isFileModified) continue;
            if (verify) {
                verifyFailed.add(matchingFile.getAbsolutePath());
                continue;
            }
            try {
                Files.write(matchingFile.toPath(), trimmedLines, Charset.forName(encoding), StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write lines to " + matchingFile.getAbsolutePath(), (Exception)e);
            }
        }
        if (!verifyFailed.isEmpty()) {
            throw new MojoFailureException("Trailing whitespace found in " + verifyFailed);
        }
    }
}

