/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.elasticjob.lite.autoconfigure;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import com.dangdang.elasticjob.lite.annotation.ElasticSimpleJob;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${elaticjob.zookeeper.server-lists}'.length() > 0")
public class ElasticJobAutoConfiguration {
    @Value(value="${elaticjob.zookeeper.server-lists}")
    private String serverList;
    @Value(value="${elaticjob.zookeeper.namespace}")
    private String namespace;
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initElasticJob() {
        ZookeeperRegistryCenter regCenter = new ZookeeperRegistryCenter(new ZookeeperConfiguration(this.serverList, this.namespace));
        regCenter.init();
        Map map = this.applicationContext.getBeansOfType(SimpleJob.class);
        for (Map.Entry entry : map.entrySet()) {
            SimpleJob simpleJob = (SimpleJob)entry.getValue();
            ElasticSimpleJob elasticSimpleJobAnnotation = simpleJob.getClass().getAnnotation(ElasticSimpleJob.class);
            String cron = (String)StringUtils.defaultIfBlank((CharSequence)elasticSimpleJobAnnotation.cron(), (CharSequence)elasticSimpleJobAnnotation.value());
            SimpleJobConfiguration simpleJobConfiguration = new SimpleJobConfiguration(JobCoreConfiguration.newBuilder((String)simpleJob.getClass().getName(), (String)cron, (int)elasticSimpleJobAnnotation.shardingTotalCount()).shardingItemParameters(elasticSimpleJobAnnotation.shardingItemParameters()).build(), simpleJob.getClass().getCanonicalName());
            LiteJobConfiguration liteJobConfiguration = LiteJobConfiguration.newBuilder((JobTypeConfiguration)simpleJobConfiguration).overwrite(true).build();
            String dataSourceRef = elasticSimpleJobAnnotation.dataSource();
            if (StringUtils.isNotBlank((CharSequence)dataSourceRef)) {
                if (!this.applicationContext.containsBean(dataSourceRef)) {
                    throw new RuntimeException("not exist datasource [" + dataSourceRef + "] !");
                }
                DataSource dataSource = (DataSource)this.applicationContext.getBean(dataSourceRef);
                JobEventRdbConfiguration jobEventRdbConfiguration = new JobEventRdbConfiguration(dataSource);
                SpringJobScheduler jobScheduler = new SpringJobScheduler((ElasticJob)simpleJob, (CoordinatorRegistryCenter)regCenter, liteJobConfiguration, (JobEventConfiguration)jobEventRdbConfiguration, new ElasticJobListener[0]);
                jobScheduler.init();
                continue;
            }
            SpringJobScheduler jobScheduler = new SpringJobScheduler((ElasticJob)simpleJob, (CoordinatorRegistryCenter)regCenter, liteJobConfiguration, new ElasticJobListener[0]);
            jobScheduler.init();
        }
    }
}

