/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.mac.MacVirtualMemory;
import oshi.util.platform.mac.SysctlUtil;

public class MacGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemory.class);

    @Override
    public long getAvailable() {
        SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
        if (0 != SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, (Structure)vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
            LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
            return 0L;
        }
        this.memAvailable = (long)(vmStats.free_count + vmStats.inactive_count) * this.getPageSize();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        long memory;
        if (this.memTotal < 0L && (memory = SysctlUtil.sysctl("hw.memsize", -1L)) >= 0L) {
            this.memTotal = memory;
        }
        return this.memTotal;
    }

    @Override
    public long getPageSize() {
        if (this.pageSize < 0L) {
            LongByReference pPageSize = new LongByReference();
            if (0 != SystemB.INSTANCE.host_page_size(SystemB.INSTANCE.mach_host_self(), pPageSize)) {
                LOG.error("Failed to get host page size. Error code: {}", (Object)Native.getLastError());
                return 0L;
            }
            this.pageSize = pPageSize.getValue();
        }
        return this.pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        if (this.virtualMemory == null) {
            this.virtualMemory = new MacVirtualMemory();
        }
        return this.virtualMemory;
    }
}

