/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacVirtualMemory
extends AbstractVirtualMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacVirtualMemory.class);

    @Override
    public long getSwapUsed() {
        this.updateSwapUsed();
        return this.swapUsed;
    }

    @Override
    public long getSwapTotal() {
        this.updateSwapUsed();
        return this.swapTotal;
    }

    @Override
    public long getSwapPagesIn() {
        this.updateSwapInOut();
        return this.swapPagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        this.updateSwapInOut();
        return this.swapPagesOut;
    }

    private void updateSwapUsed() {
        if (System.nanoTime() - this.lastSwapUsageNanos > 300000000L) {
            SystemB.XswUsage xswUsage = new SystemB.XswUsage();
            if (!SysctlUtil.sysctl("vm.swapusage", (Structure)xswUsage)) {
                return;
            }
            this.swapUsed = xswUsage.xsu_used;
            this.swapTotal = xswUsage.xsu_total;
            this.lastSwapUsageNanos = System.nanoTime();
        }
    }

    private void updateSwapInOut() {
        if (System.nanoTime() - this.lastSwapPagesNanos > 300000000L) {
            SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
            if (0 != SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, (Structure)vmStats, new IntByReference(vmStats.size() / SystemB.INT_SIZE))) {
                LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
                return;
            }
            this.swapPagesIn = ParseUtil.unsignedIntToLong(vmStats.pageins);
            this.swapPagesOut = ParseUtil.unsignedIntToLong(vmStats.pageouts);
            this.lastSwapPagesNanos = System.nanoTime();
        }
    }
}

