/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisDisks
implements Disks {
    private static final long serialVersionUID = 1L;

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(null, 0, diskStore.getName());
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            LibKstat.KstatIO data = new LibKstat.KstatIO(ksp.ks_data);
            diskStore.setReads(data.reads);
            diskStore.setWrites(data.writes);
            diskStore.setReadBytes(data.nread);
            diskStore.setWriteBytes(data.nwritten);
            diskStore.setCurrentQueueLength((long)data.wcnt + (long)data.rcnt);
            diskStore.setTransferTime(data.rtime / 1000000L);
            diskStore.setTimeStamp(ksp.ks_snaptime / 1000000L);
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        String disk;
        HashMap<String, Object> diskMap = new HashMap<String, Object>();
        List<String> disks = ExecutingCommand.runNative("iostat -er");
        HashMap<String, String> deviceMap = new HashMap<String, String>();
        List<String> mountpoints = ExecutingCommand.runNative("iostat -ern");
        for (int i = 0; i < disks.size() && i < mountpoints.size(); ++i) {
            disk = disks.get(i);
            String[] diskSplit = disk.split(",");
            if (diskSplit.length < 5 || "device".equals(diskSplit[0])) continue;
            HWDiskStore store = new HWDiskStore();
            store.setName(diskSplit[0]);
            diskMap.put(diskSplit[0], store);
            String mount = mountpoints.get(i);
            String[] mountSplit = mount.split(",");
            if (mountSplit.length < 5 || "device".equals(mountSplit[4])) continue;
            deviceMap.put(diskSplit[0], mountSplit[4]);
        }
        HashMap<String, Integer> majorMap = new HashMap<String, Integer>();
        List<String> lshal = ExecutingCommand.runNative("lshal");
        disk = "";
        for (String line : lshal) {
            if (line.startsWith("udi ")) {
                String udi = ParseUtil.getSingleQuoteStringValue(line);
                disk = udi.substring(udi.lastIndexOf(47) + 1);
                continue;
            }
            if (!(line = line.trim()).startsWith("block.major")) continue;
            majorMap.put(disk, ParseUtil.getFirstIntValue(line));
        }
        disks = ExecutingCommand.runNative("iostat -Er");
        disk = "";
        String model = "";
        String vendor = "";
        String product = "";
        String serial = "";
        long size = 0L;
        for (String line : disks) {
            String[] split;
            for (String keyValue : split = line.split(",")) {
                String[] bytes;
                keyValue = keyValue.trim();
                if (diskMap.keySet().contains(keyValue)) {
                    if (!disk.isEmpty()) {
                        this.updateStore((HWDiskStore)diskMap.get(disk), model, vendor, product, serial, size, (String)deviceMap.get(disk), majorMap.getOrDefault(disk, 0));
                    }
                    disk = keyValue;
                    model = "";
                    vendor = "";
                    product = "";
                    serial = "";
                    size = 0L;
                    continue;
                }
                if (keyValue.startsWith("Model:")) {
                    model = keyValue.replace("Model:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Serial No:")) {
                    serial = keyValue.replace("Serial No:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Vendor:")) {
                    vendor = keyValue.replace("Vendor:", "").trim();
                    continue;
                }
                if (keyValue.startsWith("Product:")) {
                    product = keyValue.replace("Product:", "").trim();
                    continue;
                }
                if (!keyValue.startsWith("Size:") || (bytes = keyValue.split("<")).length <= 1) continue;
                bytes = ParseUtil.whitespaces.split(bytes[1]);
                size = ParseUtil.parseLongOrDefault(bytes[0], 0L);
            }
            if (disk.isEmpty()) continue;
            this.updateStore((HWDiskStore)diskMap.get(disk), model, vendor, product, serial, size, (String)deviceMap.get(disk), majorMap.getOrDefault(disk, 0));
        }
        HWDiskStore[] results = new HWDiskStore[diskMap.keySet().size()];
        int index = 0;
        for (Map.Entry entry : diskMap.entrySet()) {
            SolarisDisks.updateDiskStats((HWDiskStore)entry.getValue());
            results[index++] = (HWDiskStore)entry.getValue();
        }
        return results;
    }

    private void updateStore(HWDiskStore store, String model, String vendor, String product, String serial, long size, String mount, int major) {
        store.setModel(model.isEmpty() ? (vendor + " " + product).trim() : model);
        store.setSerial(serial);
        store.setSize(size);
        ArrayList<HWPartition> partList = new ArrayList<HWPartition>();
        List<String> prtvotc = ExecutingCommand.runNative("prtvtoc /dev/dsk/" + mount);
        if (prtvotc.size() > 1) {
            int bytesPerSector = 0;
            for (String line : prtvotc) {
                String[] split;
                if (line.startsWith("*")) {
                    if (!line.endsWith("bytes/sector") || (split = ParseUtil.whitespaces.split(line)).length <= 0) continue;
                    bytesPerSector = ParseUtil.parseIntOrDefault(split[1], 0);
                    continue;
                }
                if (bytesPerSector == 0 || (split = ParseUtil.whitespaces.split(line.trim())).length < 6 || "2".equals(split[0])) continue;
                HWPartition partition = new HWPartition();
                partition.setIdentification(mount + "s" + split[0]);
                partition.setMajor(major);
                partition.setMinor(ParseUtil.parseIntOrDefault(split[0], 0));
                switch (ParseUtil.parseIntOrDefault(split[1], 0)) {
                    case 1: 
                    case 24: {
                        partition.setName("boot");
                        break;
                    }
                    case 2: {
                        partition.setName("root");
                        break;
                    }
                    case 3: {
                        partition.setName("swap");
                        break;
                    }
                    case 4: {
                        partition.setName("usr");
                        break;
                    }
                    case 5: {
                        partition.setName("backup");
                        break;
                    }
                    case 6: {
                        partition.setName("stand");
                        break;
                    }
                    case 7: {
                        partition.setName("var");
                        break;
                    }
                    case 8: {
                        partition.setName("home");
                        break;
                    }
                    case 9: {
                        partition.setName("altsctr");
                        break;
                    }
                    case 10: {
                        partition.setName("cache");
                        break;
                    }
                    case 11: {
                        partition.setName("reserved");
                        break;
                    }
                    case 12: {
                        partition.setName("system");
                        break;
                    }
                    case 14: {
                        partition.setName("public region");
                        break;
                    }
                    case 15: {
                        partition.setName("private region");
                        break;
                    }
                    default: {
                        partition.setName("unknown");
                    }
                }
                switch (split[2]) {
                    case "00": {
                        partition.setType("wm");
                        break;
                    }
                    case "10": {
                        partition.setType("rm");
                        break;
                    }
                    case "01": {
                        partition.setType("wu");
                        break;
                    }
                    default: {
                        partition.setType("ru");
                    }
                }
                partition.setSize((long)bytesPerSector * ParseUtil.parseLongOrDefault(split[4], 0L));
                if (split.length > 6) {
                    partition.setMountPoint(split[6]);
                }
                partList.add(partition);
            }
            store.setPartitions(partList.toArray(new HWPartition[0]));
        }
    }
}

