/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    WindowsFirmware() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.queryWmi();
        }
        return super.getManufacturer();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.queryWmi();
        }
        return super.getName();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.queryWmi();
        }
        return super.getDescription();
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.queryWmi();
        }
        return super.getVersion();
    }

    @Override
    public String getReleaseDate() {
        if (this.releaseDate == null) {
            this.queryWmi();
        }
        return super.getReleaseDate();
    }

    private void queryWmi() {
        WbemcliUtil.WmiQuery biosQuery = new WbemcliUtil.WmiQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult win32BIOS = WmiQueryHandler.createInstance().queryWMI(biosQuery);
        if (win32BIOS.getResultCount() > 0) {
            this.setManufacturer(WmiUtil.getString(win32BIOS, BiosProperty.MANUFACTURER, 0));
            this.setName(WmiUtil.getString(win32BIOS, BiosProperty.NAME, 0));
            this.setDescription(WmiUtil.getString(win32BIOS, BiosProperty.DESCRIPTION, 0));
            this.setVersion(WmiUtil.getString(win32BIOS, BiosProperty.VERSION, 0));
            this.setReleaseDate(WmiUtil.getDateString(win32BIOS, BiosProperty.RELEASEDATE, 0));
        }
    }

    static enum BiosProperty {
        MANUFACTURER,
        NAME,
        DESCRIPTION,
        VERSION,
        RELEASEDATE;

    }
}

