/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.hardware.Sensors;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class SensorsImpl
extends AbstractOshiJsonObject
implements Sensors {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.Sensors sensors;

    public SensorsImpl(oshi.hardware.Sensors sensors) {
        this.sensors = sensors;
    }

    @Override
    public double getCpuTemperature() {
        return this.sensors.getCpuTemperature();
    }

    @Override
    public int[] getFanSpeeds() {
        return this.sensors.getFanSpeeds();
    }

    @Override
    public double getCpuVoltage() {
        return this.sensors.getCpuVoltage();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.sensors.cpuTemperature")) {
            json.add("cpuTemperature", this.getCpuTemperature());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.sensors.fanSpeeds")) {
            JsonArrayBuilder fanSpeedsArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (int speed : this.getFanSpeeds()) {
                fanSpeedsArrayBuilder.add(speed);
            }
            json.add("fanSpeeds", (JsonValue)fanSpeedsArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.sensors.cpuVoltage")) {
            json.add("cpuVoltage", this.getCpuVoltage());
        }
        return json.build();
    }
}

