/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.maven.attribution;

import com.hazelcast.maven.attribution.AttributionContext;
import com.hazelcast.maven.attribution.ResolverComponent;
import com.hazelcast.maven.attribution.SrcFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;

public abstract class AbstractAttributionMojo
extends AbstractMojo {
    protected static final String DEFAULT_COPYRIGHT_PATTERN = "(?i)^([\\s/*]*)(((\\(c\\))|(copyright))\\s+\\S[^;{}]*)$";
    protected static final int DEFAULT_COPYRIGHT_PATTERN_GRPIDX = 2;
    protected static final String SOURCES_CLASSIFIER = "sources";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="attribution.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="attribution.parallelism", defaultValue="0")
    protected int parallelism;
    @Parameter(property="attribution.copyrightPattern", defaultValue="")
    protected volatile String copyrightPattern;
    @Parameter(property="attribution.copyrightPatternGroupIndex", defaultValue="0")
    protected volatile int copyrightPatternGroupIndex;
    @Parameter(property="attribution.serviceTimeoutMinutes", defaultValue="60")
    protected int serviceTimeoutMinutes;
    @Parameter(property="attribution.outputFile", defaultValue="${project.build.directory}/attribution.txt", required=true)
    protected File outputFile;
    @Parameter(property="attribution.exclusionPatternsFile")
    protected File exclusionPatternsFile;
    @Parameter
    protected List<String> exclusionPatterns;
    @Component
    private ResolverComponent resolverComponent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the plugin execution");
        }
        if (this.outputFile == null) {
            throw new MojoFailureException("The outputFile has to be configured");
        }
        if (this.outputFile.exists()) {
            try {
                FileUtils.forceDelete((File)this.outputFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to remove the outputFile " + this.outputFile, (Exception)e);
            }
        }
        AttributionContext context = new AttributionContext();
        this.prepareExclusionPatterns(context);
        Map<String, File> sourceJars = this.resolveSourceJars();
        int threads = this.parallelism > 0 ? this.parallelism : Runtime.getRuntime().availableProcessors();
        ExecutorService jarReaderService = Executors.newFixedThreadPool(threads);
        for (Map.Entry<String, File> entry : sourceJars.entrySet()) {
            jarReaderService.submit(() -> this.readJar((String)entry.getKey(), (File)entry.getValue(), context));
        }
        ExecutorService consumerExecutorService = Executors.newFixedThreadPool(threads);
        for (int i = 0; i < threads; ++i) {
            consumerExecutorService.submit(() -> this.consumeSrc(context));
        }
        consumerExecutorService.shutdown();
        jarReaderService.shutdown();
        try {
            jarReaderService.awaitTermination(this.serviceTimeoutMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException("JAR files processing has timed out", (Throwable)e);
        }
        context.producersRunning.set(false);
        try {
            consumerExecutorService.awaitTermination(this.serviceTimeoutMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException("Source files processing has timed out", (Throwable)e);
        }
        if (context.foundAttribution.isEmpty()) {
            this.getLog().info((CharSequence)"No attribution found in the dependencies. The output file will not be generated.");
        } else {
            this.generateResults(context);
        }
    }

    private void prepareExclusionPatterns(AttributionContext context) throws MojoExecutionException {
        if (this.exclusionPatterns != null && !this.exclusionPatterns.isEmpty()) {
            context.exclusionPatterns.addAll(this.exclusionPatterns);
        }
        if (this.exclusionPatternsFile != null && this.exclusionPatternsFile.isFile()) {
            this.getLog().debug((CharSequence)("Reading exclusionPatternsFile " + this.exclusionPatternsFile));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.exclusionPatternsFile), StandardCharsets.UTF_8));){
                String line;
                while (null != (line = reader.readLine())) {
                    if (line.isEmpty()) continue;
                    context.exclusionPatterns.add(line);
                    this.getLog().debug((CharSequence)("Added exclusionPattern '" + line + "'"));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read patterns from the exlucsionPatternFile " + this.exclusionPatternsFile.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private void generateResults(AttributionContext context) throws MojoExecutionException {
        File parentDir = this.outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.outputFile)), StandardCharsets.UTF_8));){
            for (Map.Entry gavEntry : context.foundAttribution.entrySet()) {
                Set attributionSet = (Set)gavEntry.getValue();
                String gav = (String)gavEntry.getKey();
                if (!attributionSet.isEmpty()) {
                    pw.println(gav);
                    this.getLog().debug((CharSequence)("Adding " + attributionSet.size() + " attribution(s) for " + gav));
                    for (String attribution : attributionSet) {
                        String attributionLine = "\t" + attribution;
                        pw.println(attributionLine);
                        this.getLog().debug((CharSequence)attributionLine);
                    }
                    pw.println();
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping " + gav + " as no attribution was found there."));
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to write to the outputFile " + this.outputFile, (Exception)e);
        }
        this.getLog().info((CharSequence)("Attribution file was generated: " + this.outputFile.getAbsolutePath()));
    }

    protected abstract Map<String, File> resolveSourceJars();

    private void readJar(String gav, File jar, AttributionContext context) {
        if (!jar.isFile()) {
            this.getLog().info((CharSequence)("Skipping the resolved source path as it's not a file: " + jar));
        }
        try (ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(jar)));){
            ZipEntry zipEntry;
            while (null != (zipEntry = zip.getNextEntry())) {
                String srcName = zipEntry.getName();
                if (!zipEntry.isDirectory() && this.acceptFile(srcName)) {
                    try {
                        context.srcQueue.put(new SrcFile(gav, srcName, AbstractAttributionMojo.toByteArray(zip)));
                    }
                    catch (InterruptedException e) {
                        this.getLog().warn((CharSequence)"Putting source file to queue was interrupted", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)"Reading source file failed", (Throwable)e);
                    }
                }
                zip.closeEntry();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Reading archive failed: " + jar), (Throwable)e);
        }
    }

    private boolean acceptFile(String srcName) {
        String nameLowerCase = srcName.toLowerCase(Locale.ROOT);
        return nameLowerCase.endsWith(".java") || nameLowerCase.endsWith(".xml");
    }

    private void consumeSrc(AttributionContext context) {
        String patternStr = DEFAULT_COPYRIGHT_PATTERN;
        int group = 2;
        if (this.copyrightPattern != null && !this.copyrightPattern.isEmpty()) {
            patternStr = this.copyrightPattern;
            group = this.copyrightPatternGroupIndex >= 0 ? this.copyrightPatternGroupIndex : 0;
        }
        Pattern pattern = Pattern.compile(patternStr);
        while (context.producersRunning.get() || !context.srcQueue.isEmpty()) {
            try {
                SrcFile srcFile = context.srcQueue.poll(1L, TimeUnit.SECONDS);
                this.getLog().debug((CharSequence)("Processing " + srcFile.getSourceName() + " from " + srcFile.getGav()));
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(srcFile.getBytes()), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    String line;
                    while (null != (line = reader.readLine())) {
                        Matcher m = pattern.matcher(line);
                        if (!m.find()) continue;
                        String copyrightStr = m.group(group);
                        if (this.isExcluded(context, copyrightStr)) {
                            this.getLog().debug((CharSequence)("Excluded: " + copyrightStr));
                            continue;
                        }
                        Set hitSet = context.foundAttribution.computeIfAbsent(srcFile.getGav(), s -> Collections.newSetFromMap(new ConcurrentSkipListMap()));
                        if (!hitSet.add(copyrightStr)) continue;
                        this.getLog().debug((CharSequence)("Found: " + copyrightStr));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (InterruptedException e) {
                this.getLog().debug((Throwable)e);
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    private boolean isExcluded(AttributionContext context, String copyrightStr) {
        for (String patternStr : context.exclusionPatterns) {
            Pattern p = Pattern.compile(patternStr);
            if (!p.matcher(copyrightStr).find()) continue;
            return true;
        }
        return false;
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    protected File resolve(Artifact artifact) {
        if (!SOURCES_CLASSIFIER.equals(artifact.getClassifier())) {
            return null;
        }
        Artifact resolvedArtifact = null;
        try {
            resolvedArtifact = this.resolverComponent.getResolver().resolveArtifact(this.getProjectBuildingRequest(this.project), artifact).getArtifact();
            this.getLog().debug((CharSequence)("Resolved source jar: " + resolvedArtifact.getFile()));
        }
        catch (Exception e1) {
            this.getLog().info((CharSequence)("Resolving failed for " + artifact));
        }
        return resolvedArtifact == null ? null : resolvedArtifact.getFile();
    }

    protected Artifact createResourceArtifact(Artifact artifact, String classifier) {
        DefaultArtifact a = (DefaultArtifact)this.resolverComponent.getArtifactFactory().createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", classifier);
        a.setRepository(artifact.getRepository());
        return a;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject currentProject) {
        return new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest()).setRemoteRepositories(currentProject.getRemoteArtifactRepositories());
    }

    protected static String gaKey(Artifact artifact) {
        return AbstractAttributionMojo.gaKey(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected static String gavKey(Artifact artifact) {
        return AbstractAttributionMojo.gavKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    protected static String gaKey(String gid, String aid) {
        return gid + ":" + aid;
    }

    protected static String gavKey(String gid, String aid, String version) {
        return AbstractAttributionMojo.gaKey(gid, aid) + ":" + version;
    }
}

