/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.maven.attribution;

import com.hazelcast.maven.attribution.AbstractAttributionMojo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true, inheritByDefault=false, requiresDependencyCollection=ResolutionScope.RUNTIME, threadSafe=true)
public class AggregateAttributionMojo
extends AbstractAttributionMojo {
    @Override
    protected Map<String, File> resolveSourceJars() {
        HashSet<String> projectGaSet = new HashSet<String>();
        HashSet artifacts = new HashSet();
        HashMap projectMap = new HashMap();
        if (this.reactorProjects != null) {
            for (MavenProject p : this.reactorProjects) {
                String projectGaKey = AggregateAttributionMojo.gaKey(p.getGroupId(), p.getArtifactId());
                projectGaSet.add(projectGaKey);
                List projectArtifacts = p.getRuntimeArtifacts();
                artifacts.addAll(projectArtifacts);
                this.getLog().debug((CharSequence)("Project " + projectGaKey + " artifacts: " + projectArtifacts));
            }
        } else {
            this.getLog().info((CharSequence)"Null reactorProjects");
        }
        this.getLog().debug((CharSequence)("Project GAs: " + projectGaSet));
        this.getLog().debug((CharSequence)("Artifacts size: " + artifacts.size()));
        HashMap<String, File> result = new HashMap<String, File>();
        for (Artifact artifact : artifacts) {
            String gaKey = AggregateAttributionMojo.gaKey(artifact);
            if (projectGaSet.contains(gaKey)) {
                this.getLog().debug((CharSequence)("Skipping (sub)project artifact " + gaKey));
                continue;
            }
            String gavKey = AggregateAttributionMojo.gavKey(artifact);
            File sourceFile = this.resolve(this.createResourceArtifact(artifact, "sources"));
            if (sourceFile == null) {
                this.getLog().debug((CharSequence)("No source file resolved for " + gavKey));
                continue;
            }
            this.getLog().debug((CharSequence)("Resolved " + sourceFile));
            result.put(gavKey, sourceFile);
        }
        return result;
    }
}

