/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.ClearExpiredOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.partition.IPartition;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public final class ExpirationManager {
    public static final int DEFAULT_EXPIRATION_TASK_PERIOD_SECONDS = 5;
    public static final int DEFAULT_EXPIRATION_CLEANUP_PERCENTAGE = 10;
    public static final int DIFFERENCE_BETWEEN_TWO_SUBSEQUENT_PARTITION_CLEANUP_MILLIS = 1000;
    public static final String SYS_PROP_EXPIRATION_TASK_PERIOD_SECONDS = "hazelcast.internal.map.expiration.task.period.seconds";
    public static final String SYS_PROP_EXPIRATION_CLEANUP_PERCENTAGE = "hazelcast.internal.map.expiration.cleanup.percentage";
    public static final String SYS_PROP_EXPIRATION_CLEANUP_OPERATION_COUNT = "hazelcast.internal.map.expiration.cleanup.operation.count";
    private final MapServiceContext mapServiceContext;
    private final IPartitionService partitionService;
    private final ExecutionService executionService;
    private final InternalOperationService operationService;
    private final Address thisAddress;
    private final int partitionCount;
    private final int taskPeriodSeconds;
    private final int cleanupPercentage;
    private final int cleanupOperationCount;

    public ExpirationManager(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitionService = nodeEngine.getPartitionService();
        this.executionService = nodeEngine.getExecutionService();
        this.operationService = (InternalOperationService)nodeEngine.getOperationService();
        this.thisAddress = nodeEngine.getThisAddress();
        this.partitionCount = this.partitionService.getPartitionCount();
        this.taskPeriodSeconds = Integer.getInteger(SYS_PROP_EXPIRATION_TASK_PERIOD_SECONDS, 5);
        Preconditions.checkPositive(this.taskPeriodSeconds, "taskPeriodSeconds should be a positive number");
        this.cleanupPercentage = Integer.getInteger(SYS_PROP_EXPIRATION_CLEANUP_PERCENTAGE, 10);
        Preconditions.checkTrue(this.cleanupPercentage > 0 && this.cleanupPercentage <= 100, "cleanupPercentage should be in range (0,100]");
        int defaultCleanupOpCount = ExpirationManager.calculateCleanupOperationCount(this.partitionCount, this.operationService.getPartitionThreadCount());
        this.cleanupOperationCount = Integer.getInteger(SYS_PROP_EXPIRATION_CLEANUP_OPERATION_COUNT, defaultCleanupOpCount);
        Preconditions.checkPositive(this.cleanupOperationCount, "cleanupOperationCount should be a positive number");
    }

    private static int calculateCleanupOperationCount(int partitionCount, int partitionThreadCount) {
        double scanPercentage = 0.1;
        int opCountFromPartitionCount = (int)((double)partitionCount * 0.1);
        int inflationFactor = 3;
        int opCountFromThreadCount = partitionThreadCount * 3;
        if (opCountFromPartitionCount == 0) {
            return opCountFromThreadCount;
        }
        return Math.min(opCountFromPartitionCount, opCountFromThreadCount);
    }

    public void start() {
        ClearExpiredRecordsTask task = new ClearExpiredRecordsTask();
        this.executionService.scheduleWithRepetition(task, this.taskPeriodSeconds, this.taskPeriodSeconds, TimeUnit.SECONDS);
    }

    private Operation createExpirationOperation(int expirationPercentage, int partitionId) {
        ClearExpiredOperation clearExpiredOperation = new ClearExpiredOperation(expirationPercentage);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        clearExpiredOperation.setNodeEngine(nodeEngine).setCallerUuid(nodeEngine.getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setService(this.mapServiceContext.getService());
        return clearExpiredOperation;
    }

    private void updateLastCleanupTimesBeforeSorting(List<PartitionContainer> partitionContainers) {
        for (PartitionContainer partitionContainer : partitionContainers) {
            partitionContainer.setLastCleanupTimeCopy(partitionContainer.getLastCleanupTime());
        }
    }

    int getTaskPeriodSeconds() {
        return this.taskPeriodSeconds;
    }

    int getCleanupPercentage() {
        return this.cleanupPercentage;
    }

    int getCleanupOperationCount() {
        return this.cleanupOperationCount;
    }

    private class ClearExpiredRecordsTask
    implements Runnable {
        private final Comparator<PartitionContainer> partitionContainerComparator = new Comparator<PartitionContainer>(){

            @Override
            public int compare(PartitionContainer o1, PartitionContainer o2) {
                long s2;
                long s1 = o1.getLastCleanupTimeCopy();
                return s1 < (s2 = o2.getLastCleanupTimeCopy()) ? -1 : (s1 == s2 ? 0 : 1);
            }
        };

        private ClearExpiredRecordsTask() {
        }

        @Override
        public void run() {
            long now = Clock.currentTimeMillis();
            int currentlyRunningCleanupOperationsCount = 0;
            ArrayList<PartitionContainer> partitionContainers = null;
            for (int partitionId = 0; partitionId < ExpirationManager.this.partitionCount; ++partitionId) {
                PartitionContainer partitionContainer;
                IPartition partition = ExpirationManager.this.partitionService.getPartition(partitionId, false);
                if (!partition.isOwnerOrBackup(ExpirationManager.this.thisAddress) || this.isContainerEmpty(partitionContainer = ExpirationManager.this.mapServiceContext.getPartitionContainer(partitionId))) continue;
                if (partitionContainer.hasRunningCleanup()) {
                    ++currentlyRunningCleanupOperationsCount;
                    continue;
                }
                if (currentlyRunningCleanupOperationsCount > ExpirationManager.this.cleanupOperationCount || this.notInProcessableTimeWindow(partitionContainer, now) || this.notHaveAnyExpirableRecord(partitionContainer)) continue;
                if (partitionContainers == null) {
                    partitionContainers = new ArrayList<PartitionContainer>();
                }
                partitionContainers.add(partitionContainer);
            }
            if (CollectionUtil.isEmpty(partitionContainers)) {
                return;
            }
            this.sortPartitionContainers(partitionContainers);
            this.sendCleanupOperations(partitionContainers);
        }

        private void sortPartitionContainers(List<PartitionContainer> partitionContainers) {
            ExpirationManager.this.updateLastCleanupTimesBeforeSorting(partitionContainers);
            Collections.sort(partitionContainers, this.partitionContainerComparator);
        }

        private void sendCleanupOperations(List<PartitionContainer> partitionContainers) {
            boolean start = false;
            int end = ExpirationManager.this.cleanupOperationCount;
            if (end > partitionContainers.size()) {
                end = partitionContainers.size();
            }
            List<PartitionContainer> partitionIds = partitionContainers.subList(0, end);
            for (PartitionContainer container : partitionIds) {
                container.setHasRunningCleanup(true);
                Operation operation = ExpirationManager.this.createExpirationOperation(ExpirationManager.this.cleanupPercentage, container.getPartitionId());
                ExpirationManager.this.operationService.execute(operation);
            }
        }

        private boolean notInProcessableTimeWindow(PartitionContainer partitionContainer, long now) {
            return now - partitionContainer.getLastCleanupTime() < 1000L;
        }

        private boolean isContainerEmpty(PartitionContainer container) {
            long size = 0L;
            ConcurrentMap<String, RecordStore> maps = container.getMaps();
            for (RecordStore store : maps.values()) {
                if ((size += (long)store.size()) <= 0L) continue;
                return false;
            }
            return true;
        }

        private boolean notHaveAnyExpirableRecord(PartitionContainer partitionContainer) {
            boolean notExist = true;
            ConcurrentMap<String, RecordStore> maps = partitionContainer.getMaps();
            for (RecordStore store : maps.values()) {
                if (!store.isExpirable()) continue;
                notExist = false;
                break;
            }
            return notExist;
        }
    }
}

