/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.nutz;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.resource.WebAppResourceLoader;
import org.beetl.ext.nutz.BeetlView;
import org.beetl.ext.nutz.LogErrorHandler;
import org.beetl.ext.web.WebRender;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.View;
import org.nutz.mvc.ViewMaker;

public class BeetlViewMaker
implements ViewMaker {
    private static final Log log = Logs.get();
    public GroupTemplate groupTemplate;
    public WebRender render;

    public BeetlViewMaker() throws IOException {
        String webroot = null;
        if (Mvcs.getServletContext() != null && !Strings.isBlank((CharSequence)(webroot = Mvcs.getServletContext().getRealPath("/")))) {
            BeetlUtil.setWebroot(webroot);
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        log.debug((Object)"beetl init ....");
        Configuration cfg = Configuration.defaultConfiguration();
        Properties prop = new Properties();
        InputStream ins = Configuration.class.getResourceAsStream("/beetl.properties");
        if (ins != null) {
            log.debug((Object)"found beetl.properties, loading ...");
            try {
                prop.load(ins);
            }
            finally {
                Streams.safeClose((Closeable)ins);
            }
        }
        if (!prop.containsKey("RESOURCE_LOADER")) {
            log.debug((Object)"no custom RESOURCE_LOADER found , select WebAppResourceLoader");
            cfg.setResourceLoader(WebAppResourceLoader.class.getName());
        }
        if (!prop.containsKey("DIRECT_BYTE_OUTPUT")) {
            log.debug((Object)"no custom DIRECT_BYTE_OUTPUT found , set to true");
            cfg.setDirectByteOutput(true);
        }
        if (!prop.containsKey("ERROR_HANDLER")) {
            cfg.setErrorHandlerClass(LogErrorHandler.class.getName());
        }
        this.groupTemplate = new GroupTemplate(cfg);
        this.render = new WebRender(this.groupTemplate);
        log.debug((Object)"beetl init complete");
    }

    public void depose() {
        if (this.groupTemplate != null) {
            this.groupTemplate.close();
        }
    }

    public View make(Ioc ioc, String type, String value) {
        if ("beetl".equals(type)) {
            return new BeetlView(this.render, value);
        }
        return null;
    }
}

