/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class ClientEntity {
    private final String clientId;
    private final Object syncClose;
    private boolean isClosing;
    private boolean isClosed;

    protected ClientEntity(String clientId) {
        this.clientId = clientId;
        this.syncClose = new Object();
    }

    protected abstract CompletableFuture<Void> onClose();

    public String getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getIsClosed() {
        Object object = this.syncClose;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getIsClosingOrClosed() {
        Object object = this.syncClose;
        synchronized (object) {
            return this.isClosing || this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setClosed() {
        Object object = this.syncClose;
        synchronized (object) {
            this.isClosing = false;
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setClosing() {
        Object object = this.syncClose;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletableFuture<Void> closeAsync() {
        if (this.getIsClosingOrClosed()) {
            return CompletableFuture.completedFuture(null);
        }
        Object object = this.syncClose;
        synchronized (object) {
            this.isClosing = true;
        }
        return this.onClose().thenRunAsync(() -> {
            Object object = this.syncClose;
            synchronized (object) {
                this.isClosing = false;
                this.isClosed = true;
            }
        }, MessagingFactory.INTERNAL_THREAD_POOL);
    }

    public final void close() throws ServiceBusException {
        block5: {
            try {
                this.closeAsync().get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    protected final void throwIfClosed(Throwable cause) {
        if (this.getIsClosingOrClosed()) {
            throw new IllegalStateException(String.format(Locale.US, "Operation not allowed after the %s instance is closed.", this.getClass().getName()), cause);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.getIsClosingOrClosed()) {
            this.closeAsync();
        }
        super.finalize();
    }
}

