/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.RetryPolicy;
import java.time.Duration;

public final class RetryExponential
extends RetryPolicy {
    private final Duration minimumBackoff;
    private final Duration maximumBackoff;
    private final int maximumRetryCount;
    private final double retryFactor;

    public RetryExponential(Duration minimumBackoff, Duration maximumBackoff, int maximumRetryCount, String name) {
        super(name);
        this.minimumBackoff = minimumBackoff;
        this.maximumBackoff = maximumBackoff;
        this.maximumRetryCount = maximumRetryCount;
        this.retryFactor = this.computeRetryFactor();
    }

    @Override
    protected Duration onGetNextRetryInterval(String clientId, Exception lastException, Duration remainingTime, int baseWaitTimeSecs) {
        int currentRetryCount = this.getRetryCount(clientId);
        if (currentRetryCount >= this.maximumRetryCount) {
            return null;
        }
        double nextRetryInterval = Math.pow(this.retryFactor, currentRetryCount);
        long nextRetryIntervalSeconds = (long)nextRetryInterval;
        long nextRetryIntervalNano = (long)((nextRetryInterval - (double)nextRetryIntervalSeconds) * 1.0E9);
        if ((double)remainingTime.getSeconds() < Math.max(nextRetryInterval, (double)ClientConstants.TIMER_TOLERANCE.getSeconds())) {
            return null;
        }
        Duration retryAfter = this.minimumBackoff.plus(Duration.ofSeconds(nextRetryIntervalSeconds, nextRetryIntervalNano));
        retryAfter = retryAfter.plus(Duration.ofSeconds(baseWaitTimeSecs));
        return retryAfter;
    }

    private double computeRetryFactor() {
        long deltaBackoff = this.maximumBackoff.minus(this.minimumBackoff).getSeconds();
        if (deltaBackoff <= 0L || this.maximumRetryCount <= 0) {
            return 0.0;
        }
        return Math.log(deltaBackoff) / Math.log(this.maximumRetryCount);
    }
}

