/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.commons.lang.Assert;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.StoreClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLQueryImpl;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLMergeBatch;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.sql.types.Null;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLMergeClause
extends AbstractSQLClause<SQLMergeClause>
implements StoreClause<SQLMergeClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLMergeClause.class);
    private final List<Path<?>> columns = new ArrayList();
    private final Connection connection;
    private final RelationalPath<?> entity;
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final List<Path<?>> keys = new ArrayList();
    @Nullable
    private SubQueryExpression<?> subQuery;
    private final List<SQLMergeBatch> batches = new ArrayList<SQLMergeBatch>();
    private final List<Expression<?>> values = new ArrayList();
    private transient String queryString;

    public SQLMergeClause(Connection connection, SQLTemplates templates, RelationalPath<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLMergeClause(Connection connection, Configuration configuration, RelationalPath<?> entity) {
        super(configuration);
        this.connection = (Connection)Assert.notNull((Object)connection, (String)"connection");
        this.entity = (RelationalPath)Assert.notNull(entity, (String)"entity");
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public SQLMergeClause addFlag(QueryFlag.Position position, String flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLMergeClause addFlag(QueryFlag.Position position, Expression<?> flag) {
        this.metadata.addFlag(new QueryFlag(position, flag));
        return this;
    }

    public SQLMergeClause addBatch() {
        if (!this.configuration.getTemplates().isNativeMerge()) {
            throw new IllegalStateException("batch only supported for databases that support native merge");
        }
        this.batches.add(new SQLMergeBatch(this.keys, this.columns, this.values, this.subQuery));
        this.columns.clear();
        this.values.clear();
        this.keys.clear();
        this.subQuery = null;
        return this;
    }

    public SQLMergeClause columns(Path<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public long execute() {
        if (this.configuration.getTemplates().isNativeMerge()) {
            return this.executeNativeMerge();
        }
        return this.executeCompositeMerge();
    }

    private long executeCompositeMerge() {
        SQLQuery query = (SQLQuery)new SQLQueryImpl(this.connection, this.configuration.getTemplates()).from((Expression<?>[])new Expression[]{this.entity});
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.values.get(i) instanceof NullExpression) {
                query.where(new Predicate[]{ExpressionUtils.isNull((Expression)((Expression)this.columns.get(i)))});
                continue;
            }
            query.where(new Predicate[]{ExpressionUtils.eq((Expression)((Expression)this.columns.get(i)), this.values.get(i))});
        }
        List ids = query.list((Expression)this.keys.get(0));
        if (!ids.isEmpty()) {
            SQLUpdateClause update = new SQLUpdateClause(this.connection, this.configuration.getTemplates(), this.entity);
            this.populate((StoreClause<?>)update);
            update.where(ExpressionUtils.in((Expression)((Expression)this.keys.get(0)), (Collection)ids));
            return update.execute();
        }
        SQLInsertClause insert = new SQLInsertClause(this.connection, this.configuration.getTemplates(), this.entity);
        this.populate((StoreClause<?>)insert);
        return insert.execute();
    }

    private void populate(StoreClause<?> clause) {
        for (int i = 0; i < this.columns.size(); ++i) {
            clause.set(this.columns.get(i), this.values.get(i));
        }
    }

    private PreparedStatement createStatement() throws SQLException {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        PreparedStatement stmt = null;
        if (this.batches.isEmpty()) {
            serializer.serializeForMerge(this.metadata, this.entity, this.keys, this.columns, this.values, this.subQuery);
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
        } else {
            serializer.serializeForMerge(this.metadata, this.entity, this.batches.get(0).getKeys(), this.batches.get(0).getColumns(), this.batches.get(0).getValues(), this.batches.get(0).getSubQuery());
            this.queryString = serializer.toString();
            logger.debug(this.queryString);
            stmt = this.connection.prepareStatement(this.queryString);
            this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
            stmt.addBatch();
            for (int i = 1; i < this.batches.size(); ++i) {
                SQLMergeBatch batch = this.batches.get(i);
                serializer = new SQLSerializer(this.configuration.getTemplates(), true, true);
                serializer.serializeForMerge(this.metadata, this.entity, batch.getKeys(), batch.getColumns(), batch.getValues(), batch.getSubQuery());
                this.setParameters(stmt, serializer.getConstants(), serializer.getConstantPaths(), Collections.emptyMap());
                stmt.addBatch();
            }
        }
        return stmt;
    }

    private long executeNativeMerge() {
        PreparedStatement stmt = null;
        try {
            stmt = this.createStatement();
            if (this.batches.isEmpty()) {
                long l = stmt.executeUpdate();
                return l;
            }
            long l = this.executeBatch(stmt);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + this.queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLMergeClause keys(Path<?> ... paths) {
        for (Path<?> path : paths) {
            this.keys.add(path);
        }
        return this;
    }

    public SQLMergeClause select(SubQueryExpression<?> subQuery) {
        this.subQuery = subQuery;
        return this;
    }

    public <T> SQLMergeClause set(Path<T> path, @Nullable T value) {
        this.columns.add(path);
        if (value != null) {
            this.values.add((Expression<?>)new ConstantImpl(value));
        } else {
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public <T> SQLMergeClause set(Path<T> path, Expression<? extends T> expression) {
        this.columns.add(path);
        this.values.add(expression);
        return this;
    }

    public <T> SQLMergeClause setNull(Path<T> path) {
        this.columns.add(path);
        this.values.add((Expression<?>)Null.CONSTANT);
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForMerge(this.metadata, this.entity, this.keys, this.columns, this.values, this.subQuery);
        return serializer.toString();
    }

    public SQLMergeClause values(Object ... v) {
        for (Object value : v) {
            if (value instanceof Expression) {
                this.values.add((Expression)value);
                continue;
            }
            if (value != null) {
                this.values.add((Expression<?>)new ConstantImpl(value));
                continue;
            }
            this.values.add((Expression<?>)Null.CONSTANT);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

