/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp;

import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.utils.PlaceholderPropertyResolver;
import com.mzlion.easyokhttp.cookie.CookieStore;
import com.mzlion.easyokhttp.cookie.DefaultCookieJar;
import com.mzlion.easyokhttp.cookie.MemoryCookieStore;
import com.mzlion.easyokhttp.http.DebugLoggingInterceptor;
import com.mzlion.easyokhttp.request.BinaryBodyPostRequest;
import com.mzlion.easyokhttp.request.GetRequest;
import com.mzlion.easyokhttp.request.PostRequest;
import com.mzlion.easyokhttp.request.TextBodyRequest;
import com.mzlion.easyokhttp.utils.SSLContexts;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HttpClient {
    Instance;

    public static final int DEFAULT_TIMEOUT = 10;
    private static final Logger LOGGER;
    private OkHttpClient.Builder builder;
    private CookieStore cookieStore = new MemoryCookieStore();
    private OkHttpClient okHttpClient;
    private Map<String, Map<String, String>> defaultHeaders;

    private HttpClient() {
        this.builder = new OkHttpClient.Builder().cookieJar((CookieJar)new DefaultCookieJar(this.cookieStore)).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        PlaceholderPropertyResolver propertyResolver = new PlaceholderPropertyResolver.Builder().path("classpath:easy-okhttp.properties").build();
        int timeout = (Integer)propertyResolver.getProperty("connectTimeout", Integer.TYPE);
        if (timeout <= 0) {
            timeout = 10;
        }
        this.builder.connectTimeout((long)timeout, TimeUnit.SECONDS);
        timeout = (Integer)propertyResolver.getProperty("readTimeout", Integer.TYPE);
        if (timeout <= 0) {
            timeout = 10;
        }
        this.builder.readTimeout((long)timeout, TimeUnit.SECONDS);
        timeout = (Integer)propertyResolver.getProperty("writeTimeout", Integer.TYPE);
        if (timeout <= 0) {
            timeout = 10;
        }
        this.builder.writeTimeout((long)timeout, TimeUnit.SECONDS);
        this.defaultHeaders = new ConcurrentHashMap<String, Map<String, String>>(10);
    }

    public HttpClient connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        if (connectTimeout <= 0) {
            LOGGER.error(" ===> Connect timeout must not be less than 0.");
            return this;
        }
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit may not be null.");
        this.builder.connectTimeout((long)connectTimeout, timeUnit);
        return this;
    }

    public HttpClient connectTimeout(int connectTimeout) {
        return this.connectTimeout(connectTimeout, TimeUnit.SECONDS);
    }

    public HttpClient readTimeout(int readTimeout, TimeUnit timeUnit) {
        if (readTimeout <= 0) {
            LOGGER.error(" ===> Read timeout must not be less than 0.");
            return this;
        }
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit may not be null.");
        this.builder.readTimeout((long)readTimeout, timeUnit);
        return this;
    }

    public HttpClient readTimeout(int readTimeout) {
        return this.readTimeout(readTimeout, TimeUnit.SECONDS);
    }

    public HttpClient writeTimeout(int writeTimeout, TimeUnit timeUnit) {
        if (writeTimeout <= 0) {
            LOGGER.error(" ===> Write timeout must not be less than 0.");
            return this;
        }
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit may not be null.");
        this.builder.writeTimeout((long)writeTimeout, timeUnit);
        return this;
    }

    public HttpClient writeTimeout(int writeTimeout) {
        return this.writeTimeout(writeTimeout, TimeUnit.SECONDS);
    }

    public HttpClient customSSL(InputStream ... certificates) {
        return this.customSSL((InputStream)null, (char[])null, certificates);
    }

    public HttpClient customSSL(X509TrustManager trustManager) {
        return this.customSSL(null, null, trustManager);
    }

    public HttpClient customSSL(InputStream pfxStream, char[] pfxPwd, InputStream ... certificates) {
        SSLContexts.SSLConfig sslConfig = SSLContexts.tryParse(certificates, null, pfxStream, pfxPwd);
        this.builder.sslSocketFactory(sslConfig.getSslSocketFactory(), sslConfig.getX509TrustManager());
        return this;
    }

    public HttpClient customSSL(InputStream pfxStream, char[] pfxPwd, X509TrustManager trustManager) {
        SSLContexts.SSLConfig sslConfig = SSLContexts.tryParse(null, trustManager, pfxStream, pfxPwd);
        this.builder.sslSocketFactory(sslConfig.getSslSocketFactory(), sslConfig.getX509TrustManager());
        return this;
    }

    public HttpClient setDefaultHeader(String host, String name, String value) {
        Assert.hasLength((String)host, (String)"Host may not be null or empty.");
        Assert.hasLength((String)name, (String)"Name may not be null or empty.");
        Assert.notNull((Object)value, (String)"Value may not be null.");
        HttpUrl httpUrl = HttpUrl.parse((String)host);
        if (httpUrl == null) {
            throw new IllegalArgumentException("Host [" + host + "] is invalid.");
        }
        Map<String, String> headers = this.defaultHeaders.get(httpUrl.host());
        if (CollectionUtils.isEmpty(headers)) {
            headers = new ConcurrentHashMap<String, String>();
            this.defaultHeaders.put(httpUrl.host(), headers);
        }
        headers.put(name, value);
        return this;
    }

    public Map<String, String> getDefaultHeaders(String host) {
        Assert.hasLength((String)host, (String)"Host may not be null or empty.");
        HttpUrl httpUrl = HttpUrl.parse((String)host);
        return this.getDefaultHeaders(httpUrl);
    }

    public Map<String, String> getDefaultHeaders(HttpUrl httpUrl) {
        Assert.notNull((Object)httpUrl, (String)"HttpUrl is null or invalid.");
        Map<String, String> headers = this.defaultHeaders.get(httpUrl.host());
        return headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(headers);
    }

    public HttpClient clearDefaultHeaders(String host) {
        Assert.hasLength((String)host, (String)"Host may not be null or empty.");
        HttpUrl httpUrl = HttpUrl.parse((String)host);
        return this.clearDefaultHeaders(httpUrl);
    }

    private HttpClient clearDefaultHeaders(HttpUrl httpUrl) {
        Assert.notNull((Object)httpUrl, (String)"HttpUrl is null or invalid.");
        this.defaultHeaders.remove(httpUrl.host());
        return this;
    }

    public HttpClient setCookieStore(CookieStore cookieStore) {
        Assert.notNull((Object)cookieStore, (String)"CookieStore may not be null.");
        this.cookieStore = cookieStore;
        this.builder.cookieJar((CookieJar)new DefaultCookieJar(cookieStore));
        return this;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpClient addInterceptor(Interceptor customInterceptor) {
        this.builder.addInterceptor(customInterceptor);
        return this;
    }

    public HttpClient debugLog() {
        return this.debugLog(DebugLoggingInterceptor.Level.BASIC);
    }

    public HttpClient debugLog(DebugLoggingInterceptor.Level loggingLevel) {
        DebugLoggingInterceptor instance = DebugLoggingInterceptor.INSTANCE;
        instance.setLoggingLevel(loggingLevel);
        this.builder.addInterceptor((Interceptor)instance);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            HttpClient httpClient = Instance;
            synchronized (httpClient) {
                if (this.okHttpClient == null) {
                    this.okHttpClient = this.builder.build();
                }
            }
        }
        return this.okHttpClient;
    }

    public OkHttpClient.Builder getOkHttpClientBuilder() {
        this.getOkHttpClient();
        return this.builder;
    }

    public static GetRequest get(String url) {
        return new GetRequest(url);
    }

    public static PostRequest post(String url) {
        return new PostRequest(url);
    }

    public static BinaryBodyPostRequest binaryBody(String url) {
        return new BinaryBodyPostRequest(url);
    }

    public static TextBodyRequest textBody(String url) {
        return new TextBodyRequest(url);
    }

    static {
        LOGGER = LoggerFactory.getLogger(HttpClient.class);
    }
}

