/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.cookie;

import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.easyokhttp.cookie.CookieStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class MemoryCookieStore
implements CookieStore {
    private final Map<String, List<Cookie>> allCookies = new ConcurrentHashMap<String, List<Cookie>>();

    @Override
    public void add(HttpUrl uri, List<Cookie> cookies) {
        if (uri == null) {
            throw new NullPointerException("Uri must not be null.");
        }
        if (CollectionUtils.isEmpty(cookies)) {
            throw new NullPointerException("Cookies must not be null.");
        }
        List<Cookie> oldCookies = this.allCookies.get(uri.host());
        ArrayList<Cookie> deleteCookies = new ArrayList<Cookie>(oldCookies.size());
        for (Cookie cookie : cookies) {
            for (Cookie oldCookie : oldCookies) {
                if (!oldCookie.name().equals(cookie.name())) continue;
                deleteCookies.add(oldCookie);
            }
        }
        oldCookies.removeAll(deleteCookies);
        oldCookies.addAll(cookies);
    }

    @Override
    public List<Cookie> get(HttpUrl uri) {
        if (uri == null) {
            throw new NullPointerException("Uri must not be null.");
        }
        List<Cookie> cookies = this.allCookies.get(uri.host());
        if (cookies == null) {
            cookies = new ArrayList<Cookie>();
            this.allCookies.put(uri.host(), cookies);
        }
        return cookies;
    }

    @Override
    public List<Cookie> getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(20);
        for (String host : this.allCookies.keySet()) {
            cookies.addAll((Collection<Cookie>)this.allCookies.get(host));
        }
        return cookies;
    }

    @Override
    public boolean remove(HttpUrl uri, Cookie cookie) {
        if (uri == null) {
            throw new NullPointerException("Uri must not be null.");
        }
        if (cookie == null) {
            throw new NullPointerException("Cookie must not be null.");
        }
        return this.allCookies.remove(uri.host()) != null;
    }

    @Override
    public boolean removeAll() {
        this.allCookies.clear();
        return true;
    }
}

