/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import com.mzlion.core.lang.Assert;
import com.mzlion.easyokhttp.exception.HttpClientException;
import com.mzlion.easyokhttp.http.FileRequestBody;
import com.mzlion.easyokhttp.http.InputStreamRequestBody;
import com.mzlion.easyokhttp.utils.Utils;
import java.io.File;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class FileWrapper {
    private InputStream content;
    private File file;
    private String filename;
    private MediaType mediaType;

    FileWrapper(Builder builder) {
        this.mediaType = builder.mediaType;
        this.file = builder.file;
        this.filename = builder.filename;
        this.content = builder.content;
    }

    public String getFilename() {
        return this.filename;
    }

    public static Builder create() {
        return new Builder();
    }

    public RequestBody requestBody() {
        if (this.file != null) {
            return new FileRequestBody(this.file, this.mediaType);
        }
        return new InputStreamRequestBody(this.content, this.mediaType);
    }

    public static class Builder {
        private InputStream content;
        private File file;
        private String filename;
        private MediaType mediaType;

        public Builder file(File file) {
            Assert.notNull((Object)file, (String)"File may not be null.");
            if (!file.exists()) {
                throw new HttpClientException("File does not exist.");
            }
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            Assert.hasLength((String)filename, (String)"Filename may not be null.");
            this.filename = filename;
            return this;
        }

        public Builder stream(InputStream stream) {
            Assert.notNull((Object)stream, (String)"Stream may not be null.");
            this.content = stream;
            return this;
        }

        public Builder contentType(String contentType) {
            Assert.hasLength((String)contentType, (String)"ContentType may not be null.");
            this.mediaType = MediaType.parse((String)contentType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            Assert.notNull((Object)mediaType, (String)"Media may not be null.");
            this.mediaType = mediaType;
            return this;
        }

        public FileWrapper build() {
            if (this.file != null) {
                if (this.filename == null) {
                    this.filename = this.file.getName();
                }
            } else if (this.content != null) {
                if (this.filename == null) {
                    throw new HttpClientException("Filename may not be null");
                }
            } else {
                throw new HttpClientException("The content is null.");
            }
            if (this.mediaType == null) {
                this.mediaType = Utils.guessMediaType(this.filename);
            }
            return new FileWrapper(this);
        }
    }
}

