/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;

public class CuratorFrameworkFactory {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = 15000;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;

    public static Builder builder() {
        return new Builder();
    }

    public static CuratorFramework newClient(String connectString, RetryPolicy retryPolicy) throws IOException {
        return CuratorFrameworkFactory.newClient(connectString, 15000, 10000, retryPolicy);
    }

    public static CuratorFramework newClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, RetryPolicy retryPolicy) throws IOException {
        return CuratorFrameworkFactory.builder().connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs).retryPolicy(retryPolicy).build();
    }

    private CuratorFrameworkFactory() {
    }

    public static class Builder {
        private static final ThreadFactory defaultThreadFactory = new ThreadFactoryBuilder().setNameFormat("CuratorFramework-%d").build();
        private String connectString;
        private int sessionTimeoutMs = 15000;
        private int connectionTimeoutMs = 10000;
        private RetryPolicy retryPolicy;
        private ThreadFactory threadFactory = defaultThreadFactory;
        private String namespace;
        private String authScheme = null;
        private byte[] authValue = null;
        private byte[] defaultData = new byte[0];

        public CuratorFramework build() throws IOException {
            return new CuratorFrameworkImpl(this);
        }

        public Builder authorization(String scheme, byte[] auth) {
            this.authScheme = scheme;
            this.authValue = auth != null ? Arrays.copyOf(auth, auth.length) : null;
            return this;
        }

        public Builder connectString(String connectString) {
            this.connectString = connectString;
            return this;
        }

        public Builder defaultData(byte[] defaultData) {
            this.defaultData = defaultData != null ? Arrays.copyOf(defaultData, defaultData.length) : null;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder sessionTimeoutMs(int sessionTimeoutMs) {
            this.sessionTimeoutMs = sessionTimeoutMs;
            return this;
        }

        public Builder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public String getConnectString() {
            return this.connectString;
        }

        public int getSessionTimeoutMs() {
            return this.sessionTimeoutMs;
        }

        public int getConnectionTimeoutMs() {
            return this.connectionTimeoutMs;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAuthScheme() {
            return this.authScheme;
        }

        public byte[] getAuthValue() {
            return this.authValue != null ? Arrays.copyOf(this.authValue, this.authValue.length) : null;
        }

        public byte[] getDefaultData() {
            return this.defaultData;
        }

        private Builder() {
        }
    }
}

