/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.CuratorFrameworkFactory;
import com.netflix.curator.framework.api.CreateBuilder;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.CuratorListener;
import com.netflix.curator.framework.api.DeleteBuilder;
import com.netflix.curator.framework.api.ExistsBuilder;
import com.netflix.curator.framework.api.GetACLBuilder;
import com.netflix.curator.framework.api.GetChildrenBuilder;
import com.netflix.curator.framework.api.GetDataBuilder;
import com.netflix.curator.framework.api.SetACLBuilder;
import com.netflix.curator.framework.api.SetDataBuilder;
import com.netflix.curator.framework.api.UnhandledErrorListener;
import com.netflix.curator.framework.imps.BackgroundSyncImpl;
import com.netflix.curator.framework.imps.CreateBuilderImpl;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.DeleteBuilderImpl;
import com.netflix.curator.framework.imps.ExistsBuilderImpl;
import com.netflix.curator.framework.imps.GetACLBuilderImpl;
import com.netflix.curator.framework.imps.GetChildrenBuilderImpl;
import com.netflix.curator.framework.imps.GetDataBuilderImpl;
import com.netflix.curator.framework.imps.NonNamespaceFacade;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.SetACLBuilderImpl;
import com.netflix.curator.framework.imps.SetDataBuilderImpl;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.listen.ListenerContainer;
import com.netflix.curator.framework.state.ConnectionState;
import com.netflix.curator.framework.state.ConnectionStateListener;
import com.netflix.curator.framework.state.ConnectionStateManager;
import com.netflix.curator.utils.EnsurePath;
import com.netflix.curator.utils.ZKPaths;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFrameworkImpl
implements CuratorFramework {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorZookeeperClient client;
    private final ListenerContainer<CuratorListener> listeners;
    private final ListenerContainer<UnhandledErrorListener> unhandledErrorListeners;
    private final ExecutorService executorService;
    private final BlockingQueue<OperationAndData<?>> backgroundOperations;
    private final String namespace;
    private final EnsurePath ensurePath;
    private final ConnectionStateManager connectionStateManager;
    private final AtomicReference<AuthInfo> authInfo = new AtomicReference();
    private final byte[] defaultData;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public CuratorFrameworkImpl(CuratorFrameworkFactory.Builder builder) throws IOException {
        Preconditions.checkNotNull((Object)builder.getThreadFactory());
        this.client = new CuratorZookeeperClient(builder.getConnectString(), builder.getSessionTimeoutMs(), builder.getConnectionTimeoutMs(), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                CuratorEventImpl event = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.WATCHED, watchedEvent.getState().getIntValue(), CuratorFrameworkImpl.this.unfixForNamespace(watchedEvent.getPath()), null, null, null, null, null, watchedEvent, null);
                CuratorFrameworkImpl.this.processEvent(event);
            }
        }, builder.getRetryPolicy());
        this.listeners = new ListenerContainer();
        this.unhandledErrorListeners = new ListenerContainer();
        this.backgroundOperations = new LinkedBlockingQueue();
        this.namespace = builder.getNamespace();
        this.ensurePath = this.namespace != null ? new EnsurePath(ZKPaths.makePath((String)"/", (String)this.namespace)) : null;
        this.executorService = Executors.newFixedThreadPool(2, builder.getThreadFactory());
        this.connectionStateManager = new ConnectionStateManager(this);
        byte[] builderDefaultData = builder.getDefaultData();
        byte[] byArray = this.defaultData = builderDefaultData != null ? Arrays.copyOf(builderDefaultData, builderDefaultData.length) : new byte[]{};
        if (builder.getAuthScheme() != null) {
            this.authInfo.set(new AuthInfo(builder.getAuthScheme(), builder.getAuthValue()));
        }
    }

    protected CuratorFrameworkImpl(CuratorFrameworkImpl parent) {
        this.client = parent.client;
        this.listeners = parent.listeners;
        this.unhandledErrorListeners = parent.unhandledErrorListeners;
        this.executorService = parent.executorService;
        this.backgroundOperations = parent.backgroundOperations;
        this.connectionStateManager = parent.connectionStateManager;
        this.defaultData = parent.defaultData;
        this.namespace = null;
        this.ensurePath = null;
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == State.STARTED;
    }

    @Override
    public void start() {
        this.log.info("Starting");
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            IllegalStateException error = new IllegalStateException();
            this.log.error("Already started", (Throwable)error);
            throw error;
        }
        try {
            this.client.start();
            this.connectionStateManager.start();
            this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CuratorFrameworkImpl.this.backgroundOperationsLoop();
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.handleBackgroundOperationException(null, e);
        }
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        if (!this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            IllegalStateException error = new IllegalStateException();
            this.log.error("Already closed", (Throwable)error);
            throw error;
        }
        this.listeners.forEach(new Function<CuratorListener, Void>(){

            public Void apply(CuratorListener listener) {
                CuratorEventImpl event = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.CLOSING, 0, null, null, null, null, null, null, null, null);
                try {
                    listener.eventReceived(CuratorFrameworkImpl.this, event);
                }
                catch (Exception e) {
                    CuratorFrameworkImpl.this.log.error("Exception while sending Closing event", (Throwable)e);
                }
                return null;
            }
        });
        this.listeners.clear();
        this.unhandledErrorListeners.clear();
        this.connectionStateManager.close();
        this.client.close();
        this.executorService.shutdownNow();
    }

    @Override
    public CuratorFramework nonNamespaceView() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new NonNamespaceFacade(this);
    }

    @Override
    public CreateBuilder create() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new CreateBuilderImpl(this);
    }

    @Override
    public DeleteBuilder delete() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new DeleteBuilderImpl(this);
    }

    @Override
    public ExistsBuilder checkExists() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new ExistsBuilderImpl(this);
    }

    @Override
    public GetDataBuilder getData() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetDataBuilderImpl(this);
    }

    @Override
    public SetDataBuilder setData() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new SetDataBuilderImpl(this);
    }

    @Override
    public GetChildrenBuilder getChildren() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetChildrenBuilderImpl(this);
    }

    @Override
    public GetACLBuilder getACL() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new GetACLBuilderImpl(this);
    }

    @Override
    public SetACLBuilder setACL() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return new SetACLBuilderImpl(this);
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.connectionStateManager.getListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        return this.listeners;
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.unhandledErrorListeners;
    }

    @Override
    public void sync(String path, Object context) {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        path = this.fixForNamespace(path);
        this.internalSync(this, path, context);
    }

    protected void internalSync(CuratorFrameworkImpl impl, String path, Object context) {
        BackgroundSyncImpl operation = new BackgroundSyncImpl(impl, context);
        this.backgroundOperations.offer(new OperationAndData<String>(operation, path, null));
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client;
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return new EnsurePath(this.fixForNamespace(path));
    }

    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    ZooKeeper getZooKeeper() throws Exception {
        return this.client.getZooKeeper();
    }

    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        boolean queueOperation = false;
        if (event == null) {
            queueOperation = true;
        } else if (RetryLoop.shouldRetry((int)event.getResultCode())) {
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs())) {
                queueOperation = true;
            } else {
                KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
                Object e = null;
                try {
                    e = code != null ? KeeperException.create((KeeperException.Code)code) : null;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (e == null) {
                    e = new Exception("Unknown result code: " + event.getResultCode());
                }
                this.logError("Background operation retry gave up", (Throwable)e);
            }
        } else if (operationAndData.getCallback() != null) {
            this.sendToBackgroundCallback(operationAndData, event);
        } else {
            this.processEvent(event);
        }
        if (queueOperation) {
            this.backgroundOperations.offer(operationAndData);
        }
    }

    void logError(String reason, final Throwable e) {
        if (reason == null || reason.length() == 0) {
            reason = "n/a";
        }
        this.log.error(reason, e);
        if (e instanceof KeeperException.ConnectionLossException) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        }
        final String localReason = reason;
        this.unhandledErrorListeners.forEach(new Function<UnhandledErrorListener, Void>(){

            public Void apply(UnhandledErrorListener listener) {
                listener.unhandledError(localReason, e);
                return null;
            }
        });
    }

    String unfixForNamespace(String path) {
        String namespacePath;
        if (this.namespace != null && path != null && path.startsWith(namespacePath = ZKPaths.makePath((String)this.namespace, null))) {
            path = path.length() > namespacePath.length() ? path.substring(namespacePath.length()) : "/";
        }
        return path;
    }

    String fixForNamespace(String path) {
        if (!this.ensurePath()) {
            return "";
        }
        return ZKPaths.fixForNamespace((String)this.namespace, (String)path);
    }

    byte[] getDefaultData() {
        return this.defaultData;
    }

    private boolean ensurePath() {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client);
            }
            catch (Exception e) {
                this.logError("Ensure path threw exception", e);
                return false;
            }
        }
        return true;
    }

    private <DATA_TYPE> void sendToBackgroundCallback(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        try {
            operationAndData.getCallback().processResult(this, event);
        }
        catch (Exception e) {
            this.handleBackgroundOperationException(operationAndData, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleBackgroundOperationException(OperationAndData<?> operationAndData, Throwable e) {
        if (operationAndData != null && RetryLoop.isRetryException((Throwable)e)) {
            this.log.debug("Retry-able exception received", e);
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs())) {
                this.log.debug("Retrying operation");
                this.backgroundOperations.offer(operationAndData);
                return;
            }
            this.log.debug("Retry policy did not allow retry");
        }
        this.logError("Background exception was not retry-able or retry gave up", e);
    }

    private void backgroundOperationsLoop() {
        AuthInfo auth = this.authInfo.getAndSet(null);
        if (auth != null) {
            try {
                this.client.getZooKeeper().addAuthInfo(auth.scheme, auth.auth);
            }
            catch (Exception e) {
                this.logError("addAuthInfo for background operation threw exception", e);
                return;
            }
        }
        while (!Thread.interrupted()) {
            OperationAndData<?> operationAndData;
            try {
                operationAndData = this.backgroundOperations.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            try {
                operationAndData.callPerformBackgroundOperation();
            }
            catch (Throwable e) {
                this.handleBackgroundOperationException(operationAndData, e);
            }
        }
    }

    private void processEvent(final CuratorEvent curatorEvent) {
        this.validateConnection(curatorEvent);
        this.listeners.forEach(new Function<CuratorListener, Void>(){

            public Void apply(CuratorListener listener) {
                try {
                    TimeTrace trace = CuratorFrameworkImpl.this.client.startTracer("EventListener");
                    listener.eventReceived(CuratorFrameworkImpl.this, curatorEvent);
                    trace.commit();
                }
                catch (Exception e) {
                    CuratorFrameworkImpl.this.logError("Event listener threw exception", e);
                }
                return null;
            }
        });
    }

    private void validateConnection(CuratorEvent curatorEvent) {
        if (curatorEvent.getType() == CuratorEventType.WATCHED) {
            if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.Disconnected) {
                this.connectionStateManager.addStateChange(ConnectionState.SUSPENDED);
                this.internalSync(this, "/", null);
            } else if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.Expired) {
                this.connectionStateManager.addStateChange(ConnectionState.LOST);
            } else if (curatorEvent.getWatchedEvent().getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.connectionStateManager.addStateChange(ConnectionState.RECONNECTED);
            }
        }
    }

    private static class AuthInfo {
        final String scheme;
        final byte[] auth;

        private AuthInfo(String scheme, byte[] auth) {
            this.scheme = scheme;
            this.auth = auth;
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

