/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.DeleteBuilder;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;

    DeleteBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
    }

    @Override
    public BackgroundPathable<Void> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Background");
        this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, rc, path, null, ctx, null, null, null, null, null);
                DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.backgrounding.getContext());
    }

    @Override
    public Void forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback()), null);
        } else {
            this.pathInForeground(path);
        }
        return null;
    }

    private void pathInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Foreground");
        RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DeleteBuilderImpl.this.client.getZooKeeper().delete(path, DeleteBuilderImpl.this.version);
                return null;
            }
        });
        trace.commit();
    }
}

