/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.GetDataBuilder;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.Watching;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class GetDataBuilderImpl
implements GetDataBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private Watching watching;
    private Backgrounding backgrounding;

    GetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.watching = new Watching();
        this.backgrounding = new Backgrounding();
    }

    @Override
    public WatchPathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return new WatchPathable<byte[]>(){

            @Override
            public byte[] forPath(String path) throws Exception {
                return GetDataBuilderImpl.this.forPath(path);
            }

            @Override
            public Pathable<byte[]> watched() {
                GetDataBuilderImpl.this.watched();
                return GetDataBuilderImpl.this;
            }

            @Override
            public Pathable<byte[]> usingWatcher(Watcher watcher) {
                GetDataBuilderImpl.this.usingWatcher(watcher);
                return GetDataBuilderImpl.this;
            }
        };
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<byte[]> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Background");
        AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(GetDataBuilderImpl.this.client, CuratorEventType.GET_DATA, rc, path, null, ctx, stat, data, null, null, null);
                GetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getData(operationAndData.getData(), true, callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getData(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
        }
    }

    @Override
    public byte[] forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        byte[] responseData = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback()), null);
        } else {
            responseData = this.pathInForeground(path);
        }
        return responseData;
    }

    private byte[] pathInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = (byte[])RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] responseData = GetDataBuilderImpl.this.watching.isWatched() ? GetDataBuilderImpl.this.client.getZooKeeper().getData(path, true, GetDataBuilderImpl.this.responseStat) : GetDataBuilderImpl.this.client.getZooKeeper().getData(path, GetDataBuilderImpl.this.watching.getWatcher(), GetDataBuilderImpl.this.responseStat);
                return responseData;
            }
        });
        trace.commit();
        return responseData;
    }
}

