/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.ACLable;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.Pathable;
import com.netflix.curator.framework.api.SetACLBuilder;
import com.netflix.curator.framework.imps.ACLing;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class SetACLBuilderImpl
implements SetACLBuilder,
BackgroundPathable<Stat>,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private ACLing acling;
    private Backgrounding backgrounding;
    private int version;

    SetACLBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing();
        this.version = -1;
    }

    @Override
    public BackgroundPathable<Stat> withACL(List<ACL> aclList) {
        this.acling = new ACLing(aclList);
        return this;
    }

    @Override
    public ACLable<BackgroundPathable<Stat>> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public Pathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Stat forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback()), null);
        } else {
            resultStat = this.pathInForeground(path);
        }
        return resultStat;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("SetACLBuilderImpl-Background");
        this.client.getZooKeeper().setACL(operationAndData.getData(), this.acling.getAclList(), this.version, new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(SetACLBuilderImpl.this.client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null);
                SetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.backgrounding.getContext());
    }

    private Stat pathInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("SetACLBuilderImpl-Foreground");
        Stat resultStat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetACLBuilderImpl.this.client.getZooKeeper().setACL(path, SetACLBuilderImpl.this.acling.getAclList(), SetACLBuilderImpl.this.version);
            }
        });
        trace.commit();
        return resultStat;
    }
}

