/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class ColumnPrinter {
    private final List<List<String>> data = Lists.newArrayList();
    private final List<String> columnNames = Lists.newArrayList();
    private int margin = 2;
    private static final int DEFAULT_MARGIN = 2;

    ColumnPrinter() {
    }

    void addColumn(String columnName) {
        this.data.add(new ArrayList());
        this.columnNames.add(columnName);
    }

    void addValue(String columnName, String value) {
        this.addValue(this.columnNames.indexOf(columnName), value);
    }

    void addValue(int columnIndex, String value) {
        if (columnIndex < 0 || columnIndex >= this.data.size()) {
            throw new IllegalArgumentException();
        }
        List<String> stringList = this.data.get(columnIndex);
        stringList.add(value);
    }

    void setMargin(int margin) {
        this.margin = margin;
    }

    void print(PrintWriter out) {
        for (String s : this.generate()) {
            out.println(s);
        }
    }

    List<String> generate() {
        ArrayList lines = Lists.newArrayList();
        StringBuilder workStr = new StringBuilder();
        List<AtomicInteger> columnWidths = this.getColumnWidths();
        List<Iterator<String>> dataIterators = this.getDataIterators();
        Iterator<AtomicInteger> columnWidthIterator = columnWidths.iterator();
        for (String columnName : this.columnNames) {
            int thisWidth = columnWidthIterator.next().intValue();
            this.printValue(workStr, columnName, thisWidth);
        }
        this.pushLine(lines, workStr);
        boolean done = false;
        while (!done) {
            boolean hadValue = false;
            Iterator<Iterator<String>> rowIterator = dataIterators.iterator();
            for (AtomicInteger width : columnWidths) {
                Iterator<String> thisDataIterator = rowIterator.next();
                if (thisDataIterator.hasNext()) {
                    hadValue = true;
                    String value = thisDataIterator.next();
                    this.printValue(workStr, value, width.intValue());
                    continue;
                }
                this.printValue(workStr, "", width.intValue());
            }
            this.pushLine(lines, workStr);
            if (hadValue) continue;
            done = true;
        }
        return lines;
    }

    private void pushLine(List<String> lines, StringBuilder workStr) {
        lines.add(workStr.toString());
        workStr.setLength(0);
    }

    private void printValue(StringBuilder str, String value, int thisWidth) {
        str.append(String.format(this.widthSpec(thisWidth), value));
    }

    private String widthSpec(int thisWidth) {
        return "%-" + (thisWidth + this.margin) + "s";
    }

    private List<Iterator<String>> getDataIterators() {
        ArrayList dataIterators = Lists.newArrayList();
        for (List<String> valueList : this.data) {
            dataIterators.add(valueList.iterator());
        }
        return dataIterators;
    }

    private List<AtomicInteger> getColumnWidths() {
        ArrayList columnWidths = Lists.newArrayList();
        for (String columnName : this.columnNames) {
            columnWidths.add(new AtomicInteger(columnName.length()));
        }
        int columnIndex = 0;
        for (List<String> valueList : this.data) {
            AtomicInteger width = (AtomicInteger)columnWidths.get(columnIndex++);
            for (String value : valueList) {
                width.set(Math.max(value.length(), width.intValue()));
            }
        }
        return columnWidths;
    }
}

