/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.collect.Lists;
import com.netflix.governator.configuration.ConfigurationKeyPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeyParser {
    public static List<ConfigurationKeyPart> parse(String raw) {
        return KeyParser.parse(raw, null);
    }

    public static List<ConfigurationKeyPart> parse(String raw, Map<String, String> contextOverrides) {
        int endIndex;
        int startIndex;
        ArrayList parts = Lists.newArrayList();
        int caret = 0;
        while ((startIndex = raw.indexOf("${", caret)) >= 0 && (endIndex = raw.indexOf("}", startIndex)) >= 0) {
            if (startIndex > caret) {
                parts.add(new ConfigurationKeyPart(raw.substring(caret, startIndex), false));
            }
            if ((startIndex += 2) < endIndex) {
                String name = raw.substring(startIndex, endIndex);
                if (contextOverrides != null && contextOverrides.containsKey(name)) {
                    parts.add(new ConfigurationKeyPart(contextOverrides.get(name), false));
                } else {
                    parts.add(new ConfigurationKeyPart(name, true));
                }
            }
            caret = endIndex + 1;
        }
        if (caret < raw.length()) {
            parts.add(new ConfigurationKeyPart(raw.substring(caret), false));
        }
        if (parts.size() == 0) {
            parts.add(new ConfigurationKeyPart("", false));
        }
        return parts;
    }

    private KeyParser() {
    }
}

