/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeListener;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.guice.ModuleListBuilder;
import com.netflix.governator.guice.ModuleTransformer;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.ResourceLocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapBinder
implements Binder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Binder binder;
    private Stage stage;
    private LifecycleInjectorMode mode;
    private ModuleListBuilder modules;
    private boolean disableAutoBinding;

    BootstrapBinder(Binder binder, Stage stage, LifecycleInjectorMode mode, ModuleListBuilder modules, Collection<PostInjectorAction> actions, Collection<ModuleTransformer> transformers, boolean disableAutoBinding) {
        this.binder = binder;
        this.mode = mode;
        this.stage = stage;
        this.modules = modules;
        Multibinder transformerBinder = Multibinder.newSetBinder((Binder)binder, ModuleTransformer.class);
        Multibinder actionBinder = Multibinder.newSetBinder((Binder)binder, PostInjectorAction.class);
        for (PostInjectorAction action : actions) {
            actionBinder.addBinding().toInstance((Object)action);
        }
        for (ModuleTransformer transformer : transformers) {
            transformerBinder.addBinding().toInstance((Object)transformer);
        }
    }

    private String getBindingLocation() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement elem = stack[i];
            if (elem.getClassName().equals(BootstrapBinder.class.getCanonicalName())) continue;
            return elem.toString();
        }
        return stack[0].toString();
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this.binder.bindInterceptor(classMatcher, methodMatcher, interceptors);
    }

    public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
        this.binder.bindScope(annotationType, scope);
    }

    public LinkedBindingBuilder<PostInjectorAction> bindPostInjectorAction() {
        return Multibinder.newSetBinder((Binder)this.binder, PostInjectorAction.class).addBinding();
    }

    public LinkedBindingBuilder<ModuleTransformer> bindModuleTransformer() {
        return Multibinder.newSetBinder((Binder)this.binder, ModuleTransformer.class).addBinding();
    }

    public LinkedBindingBuilder<LifecycleListener> bindLifecycleListener() {
        return Multibinder.newSetBinder((Binder)this.binder, LifecycleListener.class).addBinding();
    }

    public LinkedBindingBuilder<ResourceLocator> bindResourceLocator() {
        return Multibinder.newSetBinder((Binder)this.binder, ResourceLocator.class).addBinding();
    }

    public LinkedBindingBuilder<ConfigurationProvider> bindConfigurationProvider() {
        return Multibinder.newSetBinder((Binder)this.binder, ConfigurationProvider.class).addBinding();
    }

    public <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        this.warnOnSpecialized(key.getTypeLiteral().getRawType());
        return this.binder.withSource((Object)this.getBindingLocation()).bind(key);
    }

    public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        this.warnOnSpecialized(typeLiteral.getRawType());
        return this.binder.withSource((Object)this.getBindingLocation()).bind(typeLiteral);
    }

    public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
        this.warnOnSpecialized(type);
        return this.binder.withSource((Object)this.getBindingLocation()).bind(type);
    }

    public AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.withSource((Object)this.getBindingLocation()).bindConstant();
    }

    public <T> void requestInjection(TypeLiteral<T> type, T instance) {
        this.binder.withSource((Object)this.getBindingLocation()).requestInjection(type, instance);
    }

    public void requestInjection(Object instance) {
        this.binder.withSource((Object)this.getBindingLocation()).requestInjection(instance);
    }

    public void requestStaticInjection(Class<?> ... types) {
        this.binder.withSource((Object)this.getBindingLocation()).requestStaticInjection((Class[])types);
    }

    public void install(Module module) {
        this.binder.withSource((Object)this.getBindingLocation()).install(module);
    }

    public void include(Class<? extends Module> module) {
        this.modules.include(module);
    }

    public void include(Class<? extends Module> ... modules) {
        this.modules.include(Lists.newArrayList((Object[])modules));
    }

    public void include(Collection<Class<? extends Module>> modules) {
        this.modules.include(modules);
    }

    public void include(Module module) {
        this.modules.include(module);
    }

    public void includeModules(Collection<? extends Module> modules) {
        this.modules.includeModules(modules);
    }

    public void includeModules(Module ... modules) {
        this.modules.includeModules(Lists.newArrayList((Object[])modules));
    }

    public void exclude(Class<? extends Module> module) {
        this.modules.exclude(module);
    }

    public void exclude(Class<? extends Module> ... modules) {
        this.modules.exclude(Lists.newArrayList((Object[])modules));
    }

    public void exclude(Collection<Class<? extends Module>> modules) {
        this.modules.exclude(modules);
    }

    public void inStage(Stage stage) {
        this.stage = stage;
    }

    public void inMode(LifecycleInjectorMode mode) {
        this.mode = mode;
    }

    public Stage currentStage() {
        return this.binder.currentStage();
    }

    public void addError(String message, Object ... arguments) {
        this.binder.addError(message, arguments);
    }

    public void addError(Throwable t) {
        this.binder.addError(t);
    }

    public void addError(Message message) {
        this.binder.addError(message);
    }

    public <T> Provider<T> getProvider(Key<T> key) {
        return this.binder.getProvider(key);
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.binder.getProvider(type);
    }

    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.binder.getMembersInjector(typeLiteral);
    }

    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.binder.getMembersInjector(type);
    }

    public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.withSource((Object)this.getBindingLocation()).bindListener(typeMatcher, listener);
    }

    public Binder withSource(Object source) {
        return this.binder.withSource(source);
    }

    public Binder skipSources(Class ... classesToSkip) {
        return this.binder.skipSources(classesToSkip);
    }

    public PrivateBinder newPrivateBinder() {
        return this.binder.newPrivateBinder();
    }

    public void requireExplicitBindings() {
        this.binder.requireExplicitBindings();
    }

    public void disableCircularProxies() {
        this.binder.disableCircularProxies();
    }

    public void disableAutoBinding() {
        this.disableAutoBinding = true;
    }

    private <T> void warnOnSpecialized(Class<T> clazz) {
        if (ConfigurationProvider.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for ConfigurationProviders");
        }
        if (LifecycleListener.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for LifecycleListener");
        }
        if (ResourceLocator.class.isAssignableFrom(clazz)) {
            this.log.warn("You should use the specialized binding method for ResourceLocator");
        }
    }

    Stage getStage() {
        return this.stage;
    }

    LifecycleInjectorMode getMode() {
        return this.mode;
    }

    boolean isDisabledAutoBinding() {
        return this.disableAutoBinding;
    }

    public <T> Provider<T> getProvider(Dependency<T> dependency) {
        return this.binder.getProvider(dependency);
    }

    public void bindListener(Matcher<? super Binding<?>> bindingMatcher, ProvisionListener ... listeners) {
        this.binder.bindListener(bindingMatcher, listeners);
    }

    public void requireAtInjectOnConstructors() {
        this.binder.requireAtInjectOnConstructors();
    }

    public void requireExactBindingAnnotations() {
        this.binder.requireExactBindingAnnotations();
    }

    public void scanModulesForAnnotatedMethods(ModuleAnnotatedMethodScanner scanner) {
        this.binder.scanModulesForAnnotatedMethods(scanner);
    }
}

