/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.guice.ModuleListBuilder;
import com.netflix.governator.guice.ModuleTransformer;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class LifecycleInjectorBuilderImpl
implements LifecycleInjectorBuilder {
    private ModuleListBuilder modules = new ModuleListBuilder();
    private Collection<Class<?>> ignoreClasses = Lists.newArrayList();
    private Collection<String> basePackages = Lists.newArrayList();
    private boolean disableAutoBinding = false;
    private List<BootstrapModule> bootstrapModules = Lists.newArrayList();
    private ClasspathScanner scanner = null;
    private Stage stage = Stage.PRODUCTION;
    private LifecycleInjectorMode lifecycleInjectorMode = LifecycleInjectorMode.REAL_CHILD_INJECTORS;
    private List<PostInjectorAction> actions = ImmutableList.of();
    private List<ModuleTransformer> transformers = ImmutableList.of();

    @Override
    public LifecycleInjectorBuilder withBootstrapModule(BootstrapModule module) {
        this.bootstrapModules = ImmutableList.of((Object)module);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalBootstrapModules(BootstrapModule ... additionalBootstrapModules) {
        return this.withAdditionalBootstrapModules((Iterable<? extends BootstrapModule>)ImmutableList.copyOf((Object[])additionalBootstrapModules));
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalBootstrapModules(Iterable<? extends BootstrapModule> additionalBootstrapModules) {
        if (additionalBootstrapModules != null) {
            this.bootstrapModules = ImmutableList.builder().addAll(this.bootstrapModules).addAll(additionalBootstrapModules).build();
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModules(Module ... modules) {
        this.modules = new ModuleListBuilder().includeModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModules(Iterable<? extends Module> modules) {
        if (modules != null) {
            this.modules = new ModuleListBuilder().includeModules(modules);
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModules(Iterable<? extends Module> additionalModules) {
        if (additionalModules != null) {
            try {
                this.modules.includeModules(additionalModules);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModules(Module ... modules) {
        return this.withAdditionalModules((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    @Override
    public LifecycleInjectorBuilder withRootModule(Class<?> rootModule) {
        if (rootModule == null) {
            return this;
        }
        return this.withModuleClass(rootModule);
    }

    @Override
    public LifecycleInjectorBuilder withModuleClass(Class<? extends Module> module) {
        if (module != null) {
            this.modules.include(module);
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleClasses(Iterable<Class<? extends Module>> modules) {
        if (modules != null) {
            this.modules.include(modules);
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleClasses(Class<?> ... modules) {
        this.modules.include((Iterable<Class<? extends Module>>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])modules), (Function)new Function<Class<?>, Class<? extends Module>>(){

            public Class<? extends Module> apply(Class<?> input) {
                return input;
            }
        })));
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModuleClasses(Iterable<Class<? extends Module>> modules) {
        this.modules.include(modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withAdditionalModuleClasses(Class<?> ... modules) {
        this.modules.include((Iterable<Class<? extends Module>>)ImmutableList.builder().addAll(Iterables.transform((Iterable)Lists.newArrayList((Object[])modules), (Function)new Function<Class<?>, Class<? extends Module>>(){

            public Class<? extends Module> apply(Class<?> input) {
                return input;
            }
        })).build());
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withoutModuleClasses(Class<? extends Module> ... modules) {
        this.modules.exclude((Iterable<Class<? extends Module>>)ImmutableList.copyOf((Object[])modules));
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withoutModuleClass(Class<? extends Module> module) {
        this.modules.exclude(module);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withoutModuleClasses(Iterable<Class<? extends Module>> modules) {
        this.modules.exclude(modules);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder ignoringAutoBindClasses(Collection<Class<?>> ignoreClasses) {
        this.ignoreClasses = ImmutableList.copyOf(ignoreClasses);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder ignoringAllAutoBindClasses() {
        this.disableAutoBinding = true;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder usingBasePackages(String ... basePackages) {
        return this.usingBasePackages(Arrays.asList(basePackages));
    }

    @Override
    public LifecycleInjectorBuilder usingBasePackages(Collection<String> basePackages) {
        this.basePackages = Lists.newArrayList(basePackages);
        return this;
    }

    @Override
    public LifecycleInjectorBuilder usingClasspathScanner(ClasspathScanner scanner) {
        this.scanner = scanner;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withMode(LifecycleInjectorMode mode) {
        this.lifecycleInjectorMode = mode;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder inStage(Stage stage) {
        this.stage = stage;
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleTransformer(ModuleTransformer filter) {
        if (filter != null) {
            this.transformers = ImmutableList.builder().addAll(this.transformers).add((Object)filter).build();
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleTransformer(Collection<? extends ModuleTransformer> filters) {
        if (this.transformers != null) {
            this.transformers = ImmutableList.builder().addAll(this.transformers).addAll(filters).build();
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withModuleTransformer(ModuleTransformer ... filters) {
        if (this.transformers != null) {
            this.transformers = ImmutableList.builder().addAll(this.transformers).addAll((Iterable)ImmutableList.copyOf((Object[])filters)).build();
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withPostInjectorAction(PostInjectorAction action) {
        this.actions = ImmutableList.builder().addAll(this.actions).add((Object)action).build();
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withPostInjectorActions(Collection<? extends PostInjectorAction> actions) {
        if (actions != null) {
            this.actions = ImmutableList.builder().addAll(this.actions).addAll(actions).build();
        }
        return this;
    }

    @Override
    public LifecycleInjectorBuilder withPostInjectorActions(PostInjectorAction ... actions) {
        this.actions = ImmutableList.builder().addAll(this.actions).addAll((Iterable)ImmutableList.copyOf((Object[])actions)).build();
        return this;
    }

    @Override
    public LifecycleInjector build() {
        try {
            return new LifecycleInjector(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public Injector createInjector() {
        return this.build().createInjector();
    }

    LifecycleInjectorBuilderImpl() {
    }

    ModuleListBuilder getModuleListBuilder() {
        return this.modules;
    }

    Collection<Class<?>> getIgnoreClasses() {
        return this.ignoreClasses;
    }

    Collection<String> getBasePackages() {
        return this.basePackages;
    }

    List<BootstrapModule> getBootstrapModules() {
        return this.bootstrapModules;
    }

    ClasspathScanner getClasspathScanner() {
        return this.scanner;
    }

    Stage getStage() {
        return this.stage;
    }

    LifecycleInjectorMode getLifecycleInjectorMode() {
        return this.lifecycleInjectorMode;
    }

    List<PostInjectorAction> getPostInjectorActions() {
        return this.actions;
    }

    List<ModuleTransformer> getModuleTransformers() {
        return this.transformers;
    }

    boolean isDisableAutoBinding() {
        return this.disableAutoBinding;
    }
}

