/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.netflix.governator.guice.annotations.Bootstrap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModulesEx {
    private static final Logger LOG = LoggerFactory.getLogger(ModulesEx.class);

    public static Module combineAndOverride(Module ... modules) {
        return ModulesEx.combineAndOverride(Arrays.asList(modules));
    }

    public static Module combineAndOverride(List<? extends Module> modules) {
        Iterator<? extends Module> iter = modules.iterator();
        Module current = Modules.EMPTY_MODULE;
        if (iter.hasNext()) {
            current = iter.next();
            if (iter.hasNext()) {
                current = Modules.override((Module[])new Module[]{current}).with(new Module[]{iter.next()});
            }
        }
        return current;
    }

    public static Module fromClass(Class<?> cls) {
        return ModulesEx.fromClass(cls, true);
    }

    public static Module fromClass(Class<?> cls, boolean override) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Annotation annot : cls.getDeclaredAnnotations()) {
            Class<? extends Annotation> type = annot.annotationType();
            Bootstrap bootstrap = type.getAnnotation(Bootstrap.class);
            if (bootstrap == null) continue;
            LOG.info("Adding Module {}", bootstrap.module());
            try {
                modules.add(bootstrap.module().getConstructor(type).newInstance(annot));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (override) {
                return Modules.override((Module[])new Module[]{ModulesEx.combineAndOverride(modules)}).with(new Module[]{(Module)cls.newInstance()});
            }
            return Modules.combine((Module[])new Module[]{Modules.combine(modules), (Module)cls.newInstance()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

