/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationFinder
extends ClassVisitor {
    private static Logger log = LoggerFactory.getLogger(AnnotationFinder.class);
    private Set<Type> annotationTypes;
    private Set<Class<?>> annotatedClasses = Collections.emptySet();
    private Set<Method> annotatedMethods = new HashSet<Method>();
    private Set<Constructor> annotatedConstructors = new HashSet<Constructor>();
    private Set<Field> annotatedFields = new HashSet<Field>();
    private String className;
    private Class<?> clazz;
    private ClassLoader classLoader;

    private Class<?> selfClass() {
        if (this.clazz == null) {
            this.clazz = this.classFromInternalName(this.className);
        }
        return this.clazz;
    }

    private Class<?> classFromInternalName(String name) {
        try {
            return Class.forName(name.replace('/', '.'), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationFinder(ClassLoader classLoader, Collection<Class<? extends Annotation>> annotations) {
        super(327680);
        this.annotationTypes = new HashSet<Type>();
        for (Class<? extends Annotation> annotation : annotations) {
            this.annotationTypes.add(Type.getType(annotation));
        }
        this.classLoader = classLoader;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type type = Type.getType((String)desc);
        for (Type annotationType : this.annotationTypes) {
            if (!annotationType.equals((Object)type)) continue;
            this.annotatedClasses = Collections.singleton(this.selfClass());
            break;
        }
        return super.visitAnnotation(desc, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new AnnotationSeekingFieldVisitor(name, super.visitField(access, name, desc, signature, value));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new AnnotationSeekingMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), name, desc);
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public Set<Method> getAnnotatedMethods() {
        return this.annotatedMethods;
    }

    public Set<Constructor> getAnnotatedConstructors() {
        return this.annotatedConstructors;
    }

    public Set<Field> getAnnotatedFields() {
        return this.annotatedFields;
    }

    private class AnnotationSeekingMethodVisitor
    extends MethodVisitor {
        String name;
        String methodDesc;

        public AnnotationSeekingMethodVisitor(MethodVisitor mv, String name, String desc) {
            super(327680, mv);
            this.name = name;
            this.methodDesc = desc;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            Type type = Type.getType((String)desc);
            for (Type annotationType : AnnotationFinder.this.annotationTypes) {
                if (!annotationType.equals((Object)type)) continue;
                Type[] args = this.methodDesc == null ? new Type[]{} : Type.getArgumentTypes((String)this.methodDesc);
                Class[] argClasses = new Class[args.length];
                block15: for (int i = 0; i < args.length; ++i) {
                    switch (args[i].getSort()) {
                        case 9: 
                        case 10: {
                            argClasses[i] = AnnotationFinder.this.classFromInternalName(args[i].getInternalName());
                            continue block15;
                        }
                        case 1: {
                            argClasses[i] = Boolean.TYPE;
                            continue block15;
                        }
                        case 3: {
                            argClasses[i] = Byte.TYPE;
                            continue block15;
                        }
                        case 2: {
                            argClasses[i] = Character.TYPE;
                            continue block15;
                        }
                        case 8: {
                            argClasses[i] = Double.TYPE;
                            continue block15;
                        }
                        case 6: {
                            argClasses[i] = Float.TYPE;
                            continue block15;
                        }
                        case 5: {
                            argClasses[i] = Integer.TYPE;
                            continue block15;
                        }
                        case 7: {
                            argClasses[i] = Long.TYPE;
                            continue block15;
                        }
                        case 4: {
                            argClasses[i] = Short.TYPE;
                        }
                    }
                }
                try {
                    if ("<init>".equals(this.name)) {
                        AnnotationFinder.this.annotatedConstructors.add(AnnotationFinder.this.selfClass().getDeclaredConstructor(argClasses));
                        break;
                    }
                    AnnotationFinder.this.annotatedMethods.add(AnnotationFinder.this.selfClass().getDeclaredMethod(this.name, argClasses));
                    break;
                }
                catch (NoClassDefFoundError e) {
                    log.info("Unable to scan constructor of '{}' NoClassDefFoundError looking for '{}'", (Object)AnnotationFinder.this.selfClass().getName(), (Object)e.getMessage());
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    private class AnnotationSeekingFieldVisitor
    extends FieldVisitor {
        String name;

        public AnnotationSeekingFieldVisitor(String name, FieldVisitor fv) {
            super(327680, fv);
            this.name = name;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            Type type = Type.getType((String)desc);
            for (Type annotationType : AnnotationFinder.this.annotationTypes) {
                if (!annotationType.equals((Object)type)) continue;
                try {
                    AnnotationFinder.this.annotatedFields.add(AnnotationFinder.this.selfClass().getDeclaredField(this.name));
                    break;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
            return super.visitAnnotation(desc, visible);
        }
    }
}

