/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.TypeLiteral;
import com.netflix.governator.lifecycle.DefaultLifecycleListener;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.LifecycleState;
import java.util.Arrays;
import java.util.Collection;

public class FilteredLifecycleListener
extends DefaultLifecycleListener {
    private final ImmutableSet<String> packages;
    private final LifecycleListener listener;

    public FilteredLifecycleListener(LifecycleListener listener, String ... basePackages) {
        this(listener, Sets.newHashSet(Arrays.asList(basePackages)));
    }

    public FilteredLifecycleListener(LifecycleListener listener, Collection<String> basePackages) {
        this.listener = listener;
        this.packages = ImmutableSet.copyOf(basePackages);
    }

    @Override
    public <T> void objectInjected(TypeLiteral<T> type, T obj) {
        if (this.isInPackages(obj)) {
            this.listener.objectInjected(type, obj);
        }
    }

    @Override
    public void stateChanged(Object obj, LifecycleState newState) {
        if (this.isInPackages(obj)) {
            this.listener.stateChanged(obj, newState);
        }
    }

    private boolean isInPackages(Object obj) {
        if (obj != null) {
            return this.isInPackages(obj.getClass());
        }
        return false;
    }

    private boolean isInPackages(Class type) {
        if (type != null) {
            for (String p : this.packages) {
                if (!type.getPackage().getName().startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }
}

