/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.DefaultConfigurationMapper;
import com.netflix.governator.lifecycle.LifecycleConfigurationProviders;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.PostStartArguments;
import com.netflix.governator.lifecycle.ResourceLocator;
import com.netflix.governator.lifecycle.warmup.WarmUpException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleManagerArguments {
    private static final Logger log = LoggerFactory.getLogger(LifecycleManagerArguments.class);
    @VisibleForTesting
    public static final long DEFAULT_WARM_UP_PADDING_MS = TimeUnit.SECONDS.toMillis(3L);
    @Inject
    private ConfigurationProvider configurationProvider;
    @Inject
    private ConfigurationMapper configurationMapper;
    @Inject
    private ConfigurationDocumentation configurationDocumentation;
    @Inject(optional=true)
    private Set<LifecycleListener> lifecycleListeners = ImmutableSet.of();
    @Inject(optional=true)
    private Set<ResourceLocator> resourceLocators = ImmutableSet.of();
    @Inject(optional=true)
    private PostStartArguments postStartArguments = new PostStartArguments(){

        @Override
        public PostStartArguments.WarmUpErrorHandler getWarmUpErrorHandler() {
            return new PostStartArguments.WarmUpErrorHandler(){

                @Override
                public void warmUpError(WarmUpException exception) {
                    log.error("warm-up error after LifecycleManager.start() has been called.", (Throwable)exception);
                }
            };
        }

        @Override
        public long getWarmUpPaddingMs() {
            return DEFAULT_WARM_UP_PADDING_MS;
        }
    };

    @Inject
    public LifecycleManagerArguments(ConfigurationDocumentation configurationDocumentation, ConfigurationMapper configurationMapper, ConfigurationProvider configurationProvider) {
        this.configurationDocumentation = configurationDocumentation;
        this.configurationMapper = configurationMapper;
        this.configurationProvider = configurationProvider;
    }

    public LifecycleManagerArguments() {
        this.configurationDocumentation = new ConfigurationDocumentation();
        this.configurationProvider = new LifecycleConfigurationProviders(new ConfigurationProvider[0]);
        this.configurationMapper = new DefaultConfigurationMapper();
    }

    public ConfigurationMapper getConfigurationMapper() {
        return this.configurationMapper;
    }

    public void setConfigurationMapper(ConfigurationMapper configurationMapper) {
        this.configurationMapper = configurationMapper;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public Collection<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public void setLifecycleListeners(Collection<LifecycleListener> lifecycleListeners) {
        this.lifecycleListeners = ImmutableSet.copyOf(lifecycleListeners);
    }

    public PostStartArguments getPostStartArguments() {
        return this.postStartArguments;
    }

    public void setPostStartArguments(PostStartArguments postStartArguments) {
        this.postStartArguments = postStartArguments;
    }

    public Set<ResourceLocator> getResourceLocators() {
        return this.resourceLocators;
    }

    public void setResourceLocators(Set<ResourceLocator> resourceLocators) {
        this.resourceLocators = ImmutableSet.copyOf(resourceLocators);
    }

    public void setConfigurationDocumentation(ConfigurationDocumentation configurationDocumentation) {
        this.configurationDocumentation = configurationDocumentation;
    }

    public ConfigurationDocumentation getConfigurationDocumentation() {
        return this.configurationDocumentation;
    }
}

