/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle.warmup;

import com.netflix.governator.lifecycle.warmup.WarmUpErrors;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class WarmUpException
extends Exception {
    private final WarmUpErrors errors;

    WarmUpException(WarmUpErrors errors) {
        this.errors = errors;
    }

    public WarmUpErrors getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (WarmUpErrors.Error error : this.errors) {
            if (first) {
                first = false;
            } else {
                str.append("; ");
            }
            str.append(error.getContext());
            String message = error.getException().getMessage();
            if (message == null) continue;
            str.append(": ").append(message);
        }
        return str.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(s));
        this.printStackTrace(out);
        out.close();
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        boolean first = true;
        for (WarmUpErrors.Error error : this.errors) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            out.println(error.getContext());
            error.getException().printStackTrace(out);
        }
    }
}

