/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.OHTableClient;
import com.alipay.oceanbase.hbase.util.KeyDefiner;
import com.alipay.oceanbase.hbase.util.OHTableFactory;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;

public class OHTablePool
implements Closeable {
    private String originTabelName = null;
    private final PoolMap<String, Table> tables;
    private final int maxSize;
    private final PoolMap.PoolType poolType;
    private final Configuration config;
    private final OHTableFactory tableFactory;
    private ConcurrentHashMap<String, byte[]> tableAttributes;
    private ConcurrentHashMap<String, Object> tableExtendAttributes;

    public OHTablePool() {
        this(new Configuration(), Integer.MAX_VALUE);
    }

    public OHTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null, null);
    }

    public OHTablePool(Configuration config, int maxSize, OHTableFactory tableFactory) {
        this(config, maxSize, tableFactory, PoolMap.PoolType.Reusable);
    }

    public OHTablePool(Configuration config, int maxSize, PoolMap.PoolType poolType) {
        this(config, maxSize, null, poolType);
    }

    public OHTablePool(Configuration config, int maxSize, OHTableFactory tableFactory, PoolMap.PoolType poolType) {
        this(config, maxSize, null, null, poolType);
    }

    public OHTablePool(Configuration config, int maxSize, OHTableFactory tableFactory, ExecutorService createTableExecutor, PoolMap.PoolType poolType) {
        this.config = config == null ? new Configuration() : config;
        this.maxSize = maxSize;
        this.tableFactory = tableFactory == null ? (createTableExecutor == null ? new OHTableFactory(this.config, this) : new OHTableFactory(this.config, this, createTableExecutor)) : tableFactory;
        if (poolType == null) {
            this.poolType = PoolMap.PoolType.Reusable;
        } else {
            switch (poolType) {
                case Reusable: 
                case ThreadLocal: {
                    this.poolType = poolType;
                    break;
                }
                default: {
                    this.poolType = PoolMap.PoolType.Reusable;
                }
            }
        }
        this.tables = new PoolMap(this.poolType, this.maxSize);
    }

    public Table getTable(String tableName) {
        Table table = this.findOrCreateTable(tableName);
        if (table instanceof PooledOHTable) {
            return table;
        }
        return new PooledOHTable(table);
    }

    private Table findOrCreateTable(String tableName) {
        Table table = (Table)this.tables.get((Object)tableName);
        if (table == null) {
            table = this.createHTable(tableName);
        }
        return table;
    }

    public Table getTable(byte[] tableName) {
        return this.getTable(Bytes.toString((byte[])tableName));
    }

    public void putTable(Table table) throws IOException {
        if (!(table instanceof PooledOHTable)) {
            throw new IllegalArgumentException("not a pooled table: " + table);
        }
        this.returnTable(((PooledOHTable)table).getWrappedTable());
    }

    private void returnTable(Table table) throws IOException {
        String tableName = Bytes.toString((byte[])table.getName().getName());
        if (this.tables.size((Object)tableName) >= this.maxSize) {
            this.tables.remove((Object)tableName, (Object)table);
            this.tableFactory.releaseHTableInterface(table);
            return;
        }
        this.tables.put((Object)tableName, (Object)table);
    }

    protected Table createHTable(String tableName) {
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes((String)tableName));
    }

    public void closeTablePool(String tableName) throws IOException {
        Collection tables = this.tables.values((Object)tableName);
        if (tables != null) {
            for (Table table : tables) {
                this.tableFactory.releaseHTableInterface(table);
            }
        }
        this.tables.remove((Object)tableName);
    }

    public void closeTablePool(byte[] tableName) throws IOException {
        this.closeTablePool(Bytes.toString((byte[])tableName));
    }

    @Override
    public void close() throws IOException {
        for (String tableName : this.tables.keySet()) {
            this.closeTablePool(tableName);
        }
        this.tables.clear();
        if (this.tableFactory != null && this.tableFactory instanceof OHTableFactory) {
            this.tableFactory.close();
        }
    }

    int getCurrentPoolSize(String tableName) {
        return this.tables.size((Object)tableName);
    }

    public void setParamUrl(String tableName, String paramUrl) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.paramURL", Bytes.toBytes((String)paramUrl));
    }

    public String getParamUrl(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.paramURL"));
    }

    public void setFullUserName(String tableName, String fullUserName) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.fullUserName", Bytes.toBytes((String)fullUserName));
    }

    public String getFullUserName(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.fullUserName"));
    }

    public void setPassword(String tableName, String password) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.password", Bytes.toBytes((String)password));
    }

    public String getPassword(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.password"));
    }

    public void setSysUserName(String tableName, String sysUserName) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.sysUserName", Bytes.toBytes((String)sysUserName));
    }

    public String getSysUserName(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.sysPassword"));
    }

    public void setSysPassword(String tableName, String sysPassword) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.sysPassword", Bytes.toBytes((String)sysPassword));
    }

    public String getSysPassword(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.sysPassword"));
    }

    public void setAutoFlush(String tableName, boolean autoFlush) {
        this.setAutoFlush(tableName, autoFlush, autoFlush);
    }

    public void setAutoFlush(String tableName, boolean autoFlush, boolean clearBufferOnFail) {
        this.setTableAttribute(tableName, "hbase.htable.pool.auto.flush", Bytes.toBytes((boolean)autoFlush));
        this.setTableAttribute(tableName, "hbase.htable.pool.clear.buffer.on.fail", Bytes.toBytes((boolean)clearBufferOnFail));
    }

    public boolean getAutoFlush(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.auto.flush");
        return attr == null || Bytes.toBoolean((byte[])attr);
    }

    public boolean getClearBufferOnFail(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.clear.buffer.on.fail");
        return attr == null || Bytes.toBoolean((byte[])attr);
    }

    public void setWriteBufferSize(String tableName, long writeBufferSize) throws IOException {
        this.setTableAttribute(tableName, "hbase.htable.pool.write.buffer.size", Bytes.toBytes((long)writeBufferSize));
    }

    public long getWriteBufferSize(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.write.buffer.size");
        return attr == null ? this.config.getLong("hbase.client.write.buffer", 0x200000L) : Bytes.toLong((byte[])attr);
    }

    public String getOriginTableName() {
        return this.originTabelName;
    }

    public void setOperationTimeout(String tableName, int operationTimeout) {
        this.setTableAttribute(tableName, "hbase.htable.pool.operation.timeout", Bytes.toBytes((int)operationTimeout));
    }

    public void refreshTableEntry(String tableName, String family, boolean hasTestLoad) throws Exception {
        ((OHTable)((PooledOHTable)this.getTable(tableName)).getTable()).refreshTableEntry(family, hasTestLoad);
    }

    public int getOperationTimeout(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.operation.timeout");
        if (attr == null) {
            return 1200000;
        }
        return Bytes.toInt((byte[])attr);
    }

    public void setOdpAddr(String tableName, String odpAddr) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.odpAddr", Bytes.toBytes((String)odpAddr));
    }

    public String getOdpAddr(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpAddr");
        if (attr == null) {
            return "";
        }
        return Bytes.toString((byte[])attr);
    }

    public void setOdpPort(String tableName, int odpPort) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.odpPort", Bytes.toBytes((int)odpPort));
    }

    public int getOdpPort(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpPort");
        return attr == null ? this.config.getInt("hbase.oceanbase.odpPort", -1) : Bytes.toInt((byte[])attr);
    }

    public void setOdpMode(String tableName, boolean odpMode) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.odpMode", Bytes.toBytes((boolean)odpMode));
    }

    public boolean getOdpMode(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpMode");
        return attr != null && Bytes.toBoolean((byte[])attr);
    }

    public void setDatabase(String tableName, String database) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableAttribute(tableName, "hbase.oceanbase.database", Bytes.toBytes((String)database));
    }

    public String getDatabase(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.database");
        if (attr == null) {
            return "";
        }
        return Bytes.toString((byte[])attr);
    }

    private void setTableAttribute(String tableName, String attributeName, byte[] value) {
        if (this.tableAttributes == null && value == null) {
            return;
        }
        if (this.tableAttributes == null) {
            this.tableAttributes = new ConcurrentHashMap();
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        if (value == null) {
            this.tableAttributes.remove(name);
            if (this.tableAttributes.isEmpty()) {
                this.tableAttributes = null;
            }
        } else {
            this.tableAttributes.put(name, value);
        }
    }

    public byte[] getTableAttribute(String tableName, String attributeName) {
        if (this.tableAttributes == null) {
            return null;
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        return this.tableAttributes.get(name);
    }

    private void setTableExtendAttribute(String tableName, String attributeName, Object value) {
        if (this.tableExtendAttributes == null && value == null) {
            return;
        }
        if (this.tableExtendAttributes == null) {
            this.tableExtendAttributes = new ConcurrentHashMap();
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        if (value == null) {
            this.tableExtendAttributes.remove(name);
            if (this.tableExtendAttributes.isEmpty()) {
                this.tableExtendAttributes = null;
            }
        } else {
            this.tableExtendAttributes.put(name, value);
        }
    }

    public Object getTableExtendAttribute(String tableName, String attributeName) {
        if (this.tableExtendAttributes == null) {
            return null;
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        return this.tableExtendAttributes.get(name);
    }

    public void setRuntimeBatchExecutor(String tableName, ExecutorService runtimeBatchExecutor) {
        if (this.originTabelName == null) {
            this.originTabelName = tableName;
        }
        this.setTableExtendAttribute(tableName, "hbase.oceanbase.batch.executor", runtimeBatchExecutor);
    }

    public ExecutorService getRuntimeBatchExecutor(String tableName) {
        return (ExecutorService)this.getTableExtendAttribute(tableName, "hbase.oceanbase.batch.executor");
    }

    public class PooledOHTable
    implements Table {
        private Table table;

        public PooledOHTable(Table table) {
            this.table = table;
        }

        public TableName getName() {
            return this.table.getName();
        }

        public Configuration getConfiguration() {
            return this.table.getConfiguration();
        }

        public HTableDescriptor getTableDescriptor() throws IOException {
            return this.table.getTableDescriptor();
        }

        public TableDescriptor getDescriptor() throws IOException {
            return this.table.getDescriptor();
        }

        public boolean exists(Get get) throws IOException {
            return this.table.exists(get);
        }

        public boolean[] existsAll(List<Get> list) throws IOException {
            return this.table.existsAll(list);
        }

        public boolean[] exists(List<Get> gets) throws IOException {
            return this.table.exists(gets);
        }

        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
            this.table.batch(actions, results);
        }

        public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.table.batchCallback(actions, results, callback);
        }

        public Result get(Get get) throws IOException {
            return this.table.get(get);
        }

        public Result[] get(List<Get> gets) throws IOException {
            return this.table.get(gets);
        }

        public ResultScanner getScanner(Scan scan) throws IOException {
            return this.table.getScanner(scan);
        }

        public ResultScanner getScanner(byte[] family) throws IOException {
            return this.table.getScanner(family);
        }

        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
            return this.table.getScanner(family, qualifier);
        }

        public List<ResultScanner> getScanners(Scan scan) throws IOException {
            if (this.table instanceof OHTableClient) {
                return ((OHTableClient)this.table).getScanners(scan);
            }
            if (this.table instanceof OHTable) {
                return ((OHTable)this.table).getScanners(scan);
            }
            throw new IllegalArgumentException("just support for OHTable and OHTableClient");
        }

        public void put(Put put) throws IOException {
            this.table.put(put);
        }

        public void put(List<Put> puts) throws IOException {
            this.table.put(puts);
        }

        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
            return this.table.checkAndPut(row, family, qualifier, value, put);
        }

        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
            return this.table.checkAndPut(row, family, qualifier, compareOp, value, put);
        }

        public void delete(Delete delete) throws IOException {
            this.table.delete(delete);
        }

        public void delete(List<Delete> deletes) throws IOException {
            this.table.delete(deletes);
        }

        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
            return this.table.checkAndDelete(row, family, qualifier, value, delete);
        }

        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
            return this.table.checkAndDelete(row, family, qualifier, compareOp, value, delete);
        }

        public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
            return this.table.checkAndMutate(row, family);
        }

        public Result increment(Increment increment) throws IOException {
            return this.table.increment(increment);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
        }

        public void close() throws IOException {
            OHTablePool.this.returnTable(this.table);
        }

        public CoprocessorRpcChannel coprocessorService(byte[] row) {
            return this.table.coprocessorService(row);
        }

        public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
            return this.table.coprocessorService(service, startKey, endKey, callable);
        }

        public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
            this.table.coprocessorService(service, startKey, endKey, callable, callback);
        }

        public String toString() {
            return "PooledOHTable{, table=" + this.table + '}';
        }

        Table getWrappedTable() {
            return this.table;
        }

        public void mutateRow(RowMutations rm) throws IOException {
            this.table.mutateRow(rm);
        }

        public Result append(Append append) throws IOException {
            return this.table.append(append);
        }

        public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
            return this.table.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
        }

        public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
            this.table.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
        }

        public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutations) throws IOException {
            return this.table.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
        }

        public void setOperationTimeout(int i) {
            this.table.setOperationTimeout(i);
        }

        public int getOperationTimeout() {
            return this.table.getOperationTimeout();
        }

        public void setRpcTimeout(int i) {
            this.table.setRpcTimeout(i);
        }

        public int getRpcTimeout() {
            return this.table.getRpcTimeout();
        }

        public Table getTable() {
            return this.table;
        }

        public byte[][] getStartKeys() throws IOException {
            return ((OHTable)this.table).getStartKeys();
        }

        public byte[][] getEndKeys() throws IOException {
            return ((OHTable)this.table).getEndKeys();
        }

        public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
            return ((OHTable)this.table).getStartEndKeys();
        }
    }
}

