/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ResultSetProxyFactory;
import oracle.ucp.jdbc.proxy.StatementProxyFactory;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class PreparedStatementProxyFactory
extends StatementProxyFactory
implements InvocationHandler {
    private static final Logger logger = UCPLoggerFactory.createLogger(PreparedStatementProxyFactory.class.getCanonicalName());

    public static Object createPreparedStatementProxy(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedStatement == null) {
            return null;
        }
        Object pstmtProxy = Proxy.newProxyInstance(proxyConnection.getClass().getClassLoader(), PreparedStatementProxyFactory.createInterfaces(proxiedStatement), (InvocationHandler)new PreparedStatementProxyFactory(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection));
        logger.log(Level.FINEST, "returns {0}", pstmtProxy);
        return pstmtProxy;
    }

    protected PreparedStatementProxyFactory(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            try {
                String methodName = method.getName();
                if (!methodName.equals("executeQuery")) {
                    if (!methodName.equals("getReturnResultSet")) return super.invoke(proxy, method, args);
                }
                this.m_jdbcPooledConnection.heartbeat();
                if (this.creationTS < this.m_jdbcPooledConnection.getAvailableStartTime() || this.creationTS < this.m_jdbcPooledConnection.getBorrowedStartTime()) {
                    this.m_closed = true;
                    this.m_proxyConnection.close();
                }
                Object result = method.invoke((Object)this.m_proxiedStatement, args);
                this.m_jdbcPooledConnection.heartbeat();
                Object proxyResultSet = ResultSetProxyFactory.createResultSetProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
                return proxyResultSet;
            }
            catch (SQLException sqlexc) {
                logger.throwing(this.getClass().getName(), "invoke", sqlexc);
                throw sqlexc;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (Util.isSQLRecoverableException(t)) {
                    this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
                }
                logger.throwing(this.getClass().getName(), "invoke", t);
                throw t;
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException("unexpected invocation exception: " + e.getMessage());
                logger.throwing(this.getClass().getName(), "invoke", re);
                throw re;
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            throw throwable;
        }
    }
}

