/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceIdGenerator {
    private static final String EMPTY_STRING = "";
    private static String P_ID_CACHE = null;
    private static String IP_16 = "ffffffff";
    private static final AtomicInteger count = new AtomicInteger(1000);

    private static String getInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotBlank(String str) {
        return !TraceIdGenerator.isBlank(str);
    }

    private static String getPID() {
        if (P_ID_CACHE != null) {
            return P_ID_CACHE;
        }
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (TraceIdGenerator.isBlank(processName)) {
            return EMPTY_STRING;
        }
        String[] processSplitName = processName.split("@");
        if (processSplitName.length == 0) {
            return EMPTY_STRING;
        }
        String pid = processSplitName[0];
        if (TraceIdGenerator.isBlank(pid)) {
            return EMPTY_STRING;
        }
        P_ID_CACHE = pid;
        return pid;
    }

    private static String getTraceId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(30);
        appender.append(ip).append(timestamp).append(nextId).append(TraceIdGenerator.getPID());
        return appender.toString();
    }

    public static String generate() {
        return TraceIdGenerator.getTraceId(IP_16, System.currentTimeMillis(), TraceIdGenerator.getNextId());
    }

    private static String getIP_16(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    static {
        try {
            String ipAddress = TraceIdGenerator.getInetAddress();
            if (ipAddress != null) {
                IP_16 = TraceIdGenerator.getIP_16(ipAddress);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

