/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.List;
import java.util.Map;

public abstract class GfJsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> T parseObject(String jsonString, Class<T> classz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(jsonString, classz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public static String toJSONString(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public static <T> List<T> parseArray(String json, Class<T> clazz) {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(json, javaType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <K, V> Map<K, V> json2Map(String jsonData, Class<K> keyType, Class<V> valueType) {
        MapType javaType = mapper.getTypeFactory().constructMapType(Map.class, keyType, valueType);
        try {
            return (Map)mapper.readValue(jsonData, (JavaType)javaType);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

