/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.RegRes;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.apps.Deck;
import com.stevesoft.pat.apps.Message;
import com.stevesoft.pat.apps.TestGroup;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Random;

public class ReGame
extends Applet {
    static final String hide_ans = "????";
    Label pat_msg;
    Label ans_msg;
    public TextField pat;
    public TextField ans_txt;
    public TestGroup[] tgroup;
    public TestGroup[] tgroup2;
    public RegRes[] answers;
    int score;
    Label unreg;
    public TextField score_txt;
    public Button home_btn;
    public Button redraw;
    boolean inited = false;
    boolean started = false;
    public Random qrand = new Random();
    int quizno;
    int p_len;
    boolean game_over = false;
    public Deck quizes;
    int max_score;
    public Message mes;

    String unescme(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '_') {
                char c;
                if ((c = string.charAt(++n)) == 'q') {
                    stringBuffer.append('\"');
                } else if (c == 'a') {
                    stringBuffer.append('&');
                } else if (c == 'l') {
                    stringBuffer.append('<');
                } else if (c == 'r') {
                    stringBuffer.append('>');
                } else if (c == 'b') {
                    stringBuffer.append('\\');
                } else {
                    stringBuffer.append('_');
                }
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void setScore(int n) {
        this.score = n;
        String string = "score: " + n;
        if (this.score_txt == null) {
            this.score_txt = new TextField(string);
            this.score_txt.setEditable(false);
            return;
        }
        ((TextComponent)this.score_txt).setText(string);
    }

    void addScore(int n) {
        this.setScore(this.score + n);
    }

    public void init() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel.setBackground(Color.red);
        panel2.setBackground(Color.green);
        panel4.setBackground(Color.blue);
        panel3.setBackground(Color.white);
        this.add(panel3);
        this.add(panel4);
        panel4.setLayout(new GridLayout(1, 2));
        panel4.add(panel);
        panel4.add(panel2);
        this.pat_msg = new Label("Pattern");
        this.pat = new TextField();
        this.ans_msg = new Label("Answer");
        this.ans_txt = new TextField();
        this.ans_txt.setEditable(false);
        ((TextComponent)this.ans_txt).setText(hide_ans);
        String string = null;
        string = this.getParameter("Title");
        if (string == null) {
            string = "ReGame";
        }
        this.unreg = new Label(string);
        this.unreg.setAlignment(1);
        this.setScore(0);
        this.home_btn = new Button("About");
        this.redraw = new Button("Redraw");
        panel3.add(this.unreg);
        panel.add(this.score_txt);
        this.score_txt.setEditable(false);
        panel2.add(this.home_btn);
        panel2.add(this.redraw);
        Panel panel5 = new Panel();
        panel5.add(this.pat_msg);
        panel5.add(this.pat);
        panel.add(panel5);
        Panel panel6 = new Panel();
        panel6.add(this.ans_msg);
        panel6.add(this.ans_txt);
        panel2.add(panel6);
        int n = new Integer(this.getParameter("NGroups"));
        this.tgroup = new TestGroup[n];
        this.tgroup2 = new TestGroup[n];
        this.answers = new RegRes[n];
        int n2 = 0;
        while (n2 < n) {
            this.tgroup[n2] = new TestGroup("text" + (n2 + 1), false);
            this.tgroup2[n2] = new TestGroup("text" + (n2 + 1), false);
            panel.add(this.tgroup[n2]);
            panel2.add(this.tgroup2[n2]);
            ++n2;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        panel2.setLayout(gridBagLayout);
        panel3.setLayout(gridBagLayout);
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.unreg, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(panel3, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(panel4, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.home_btn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.redraw, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.score_txt, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        panel5.setLayout(gridBagLayout);
        panel6.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(panel5, gridBagConstraints);
        gridBagLayout.setConstraints(panel6, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        n2 = 0;
        while (n2 < n) {
            gridBagConstraints.gridy = n2 + 2;
            gridBagLayout.setConstraints(this.tgroup[n2], gridBagConstraints);
            gridBagLayout.setConstraints(this.tgroup2[n2], gridBagConstraints);
            ++n2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.pat_msg, gridBagConstraints);
        gridBagLayout.setConstraints(this.ans_msg, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.pat, gridBagConstraints);
        gridBagLayout.setConstraints(this.ans_txt, gridBagConstraints);
    }

    public void start() {
        int n;
        if (this.started) {
            return;
        }
        this.started = true;
        int n2 = new Integer(this.getParameter("NQuizes"));
        this.quizes = new Deck(n2);
        try {
            n = new Integer(this.getParameter("NDiscards"));
        }
        catch (Throwable throwable) {
            n = 0;
        }
        while (n > 0) {
            --n;
            this.quizes.draw();
        }
        this.setScore(0);
        this.getquiz();
        this.game_over = false;
    }

    Regex getquiz() {
        if (this.quizes.ncards() == 0) {
            ((TextComponent)this.score_txt).setText("Game Over: Score " + this.score + " of " + this.max_score);
            this.game_over = true;
            return null;
        }
        this.quizno = this.quizes.draw();
        ((TextComponent)this.pat).setText("");
        ((TextComponent)this.ans_txt).setText(hide_ans);
        String string = this.unescme(this.getParameter("pat" + this.quizno));
        this.p_len = string.length();
        Regex regex = new Regex();
        RegSyntax regSyntax = null;
        try {
            regex.compile(string);
        }
        catch (RegSyntax regSyntax2) {
            regSyntax = regSyntax2;
        }
        int n = 0;
        while (n < this.tgroup.length) {
            String string2 = "txt" + (n + 1) + "-" + this.quizno;
            string2 = this.unescme(this.getParameter(string2));
            ((TextComponent)this.tgroup[n].txt).setText(string2);
            ((TextComponent)this.tgroup2[n].txt).setText(string2);
            if (regSyntax == null) {
                regex.search(string2);
                this.tgroup2[n].ShowRes(regex);
                this.tgroup[n].ctxt.clear();
                this.answers[n] = regex.result();
            } else {
                this.tgroup2[n].ShowError(regSyntax);
                this.tgroup[n].ctxt.clear();
                this.answers[n] = new RegRes();
            }
            ++n;
        }
        return regex;
    }

    public boolean action(Event event, Object object) {
        int n;
        this.repaint();
        if (event.target instanceof Button) {
            if (object.equals("About")) {
                Message message = new Message();
                message.setTitle("About");
                message.addCentered("ReGame");
                message.addCentered("A regular expression game");
                message.addCentered("by Steven R. Brandt");
                message.addCentered("Home page at");
                message.addCentered("http://javaregex.com");
                message.addButton(new Button("OK"));
                message.ask(this);
                return true;
            }
            int n2 = 0;
            while (n2 < this.tgroup.length) {
                this.tgroup[n2].repaint();
                ++n2;
            }
            n = 0;
            while (n < this.tgroup2.length) {
                this.tgroup2[n].repaint();
                ++n;
            }
        }
        if (event.target instanceof Message) {
            Message message = (Message)event.target;
            if (message.getTitle().equals("About")) {
                return true;
            }
            n = 0;
            while (n < this.tgroup.length) {
                this.tgroup[n].ctxt.clear();
                this.tgroup[n].ctxt.clear();
                ++n;
            }
            this.getquiz();
            this.mes = null;
            return true;
        }
        if (event.target instanceof TextField && this.mes == null) {
            if (this.game_over) {
                return true;
            }
            String string = this.pat.getText();
            Regex regex = new Regex(string);
            this.mes = new Message();
            this.mes.setTitle("Score");
            ((TextComponent)this.ans_txt).setText(this.unescme(this.getParameter("pat" + this.quizno)));
            Regex regex2 = new Regex(this.ans_txt.getText());
            int n3 = 0;
            while (n3 < this.tgroup.length) {
                regex.search(this.tgroup[n3].txt.getText());
                regex2.search(this.tgroup2[n3].txt.getText());
                RegRes regRes = regex.result();
                this.tgroup2[n3].ShowRes(regex2);
                this.tgroup[n3].ShowRes(regex);
                if (regRes.equals(this.answers[n3])) {
                    String string2;
                    if (string.length() > this.p_len) {
                        string2 = "Long Match: 5 pts";
                        this.addScore(5);
                    } else if (string.length() == this.p_len) {
                        string2 = "Match: 10 pts";
                        this.addScore(10);
                    } else {
                        string2 = "Short Match: 12 pts";
                        this.addScore(12);
                    }
                    this.mes.v.addElement(new Label(string2));
                } else {
                    System.out.println("user: " + regRes);
                    System.out.println("answ: " + this.answers[n3]);
                    this.mes.v.addElement(new Label("No Match"));
                }
                this.max_score += 10;
                ++n3;
            }
            this.mes.v.addElement(new Button("OK"));
            this.mes.ask(this);
            return true;
        }
        return false;
    }
}

