/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.context.chart;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiOptions;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiInteractionDataGeom;
import com.stimulsoft.base.context.chart.geoms.StiBorderGeom;
import com.stimulsoft.base.context.chart.geoms.StiCachedShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiCurveGeom;
import com.stimulsoft.base.context.chart.geoms.StiEllipseGeom;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopSmothingModeGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopTextRenderingHintGeom;
import com.stimulsoft.base.context.chart.geoms.StiPopTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushClipGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushRotateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushSmothingModeToAntiAliasGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushTextRenderingHintToAntiAliasGeom;
import com.stimulsoft.base.context.chart.geoms.StiPushTranslateTransformGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiShadowGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.context.chart.geoms.StiTextGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiBorderAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiClusteredBarSeriesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiClusteredColumnSeriesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiCurveAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiEllipseAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiLabelAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiLinesAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiPathAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiPathElementAnimationGeom;
import com.stimulsoft.base.context.chart.geoms.animaton.StiShadowAnimationGeom;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.util.ArrayList;
import java.util.List;

public class StiContext {
    public StiOptions Options;
    private IStiContextPainter contextPainter;
    private List<StiGeom> geoms = new ArrayList<StiGeom>();

    public StiContext(IStiContextPainter contextPainter, Boolean isGdi, Boolean isWpf, Boolean isPrinting, float zoom) {
        this.contextPainter = contextPainter;
        this.Options = new StiOptions((int)zoom, isPrinting);
    }

    public void render(StiRectangle rect) {
        this.contextPainter.render(rect, this.geoms);
    }

    public StiStringFormatGeom GetDefaultStringFormat() {
        return this.contextPainter.getDefaultStringFormat();
    }

    public StiStringFormatGeom GetGenericStringFormat() {
        return this.contextPainter.getGenericStringFormat();
    }

    public StiTextGeom DrawString(String text, StiFontGeom font, Object brush, StiRectangle rect, StiStringFormatGeom sf) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, rect, sf, false);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiTextGeom DrawRotatedString(String text, StiFontGeom font, Object brush, StiRectangle rect, StiStringFormatGeom sf, float angle, boolean antialiasing) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, rect, sf, angle, antialiasing, true);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiTextGeom DrawRotatedString(String text, StiFontGeom font, Object brush, StiPoint pos, StiStringFormatGeom sf, StiRotationMode mode, float angle, boolean antialiasing) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, pos, sf, angle, antialiasing, mode, true);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiTextGeom DrawRotatedString(String text, StiFontGeom font, Object brush, StiRectangle rect, StiStringFormatGeom sf, StiRotationMode mode, float angle, boolean antialiasing, int maximalWidth) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, rect, sf, angle, antialiasing, maximalWidth, mode, true);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiTextGeom DrawRotatedString(String text, StiFontGeom font, Object brush, StiRectangle rect, StiStringFormatGeom sf, StiRotationMode mode, float angle, boolean antialiasing) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, rect, sf, angle, antialiasing, mode, true);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiTextGeom DrawRotatedString(String text, StiFontGeom font, Object brush, StiPoint pos, StiStringFormatGeom sf, StiRotationMode mode, float angle, boolean antialiasing, int maximalWidth) {
        StiTextGeom textGeom = new StiTextGeom(text, font, brush, pos, sf, angle, antialiasing, maximalWidth, mode, true);
        this.geoms.add(textGeom);
        return textGeom;
    }

    public StiSize MeasureString(String text, StiFontGeom font) {
        return this.contextPainter.measureString(text, font);
    }

    public StiSize MeasureString(String text, StiFontGeom font, int width, StiStringFormatGeom sf) {
        return this.contextPainter.measureString(text, font, width, sf);
    }

    public StiRectangle MeasureRotatedString(String text, StiFontGeom font, StiRectangle rect, StiStringFormatGeom sf, float angle) {
        return this.contextPainter.measureRotatedString(text, font, rect, sf, angle);
    }

    public StiRectangle MeasureRotatedString(String text, StiFontGeom font, StiRectangle rect, StiStringFormatGeom sf, StiRotationMode mode, double angle) {
        return this.contextPainter.measureRotatedString(text, font, rect, sf, mode, angle);
    }

    public StiRectangle MeasureRotatedString(String text, StiFontGeom font, StiPoint point, StiStringFormatGeom sf, StiRotationMode mode, float angle, int maximalWidth) {
        return this.contextPainter.measureRotatedString(text, font, point, sf, mode, angle, maximalWidth);
    }

    public StiRectangle MeasureRotatedString(String text, StiFontGeom font, StiPoint point, StiStringFormatGeom sf, StiRotationMode mode, float angle) {
        return this.contextPainter.measureRotatedString(text, font, point, sf, mode, (double)angle);
    }

    public void DrawShadow(StiContext sg, StiRectangle rect, double radius) {
        this.geoms.add(new StiShadowGeom(sg, rect, radius));
    }

    public void drawCachedShadow(StiRectangle rect, StiEnumSet<StiShadowSides> sides, boolean isPrinting) {
        this.geoms.add(new StiCachedShadowGeom(rect, sides, isPrinting));
    }

    public StiContext CreateShadowGraphics() {
        return this.contextPainter.createShadowGraphics(this.Options.isPrinting, this.Options.zoom);
    }

    public void PushTranslateTransform(double x, double y) {
        this.geoms.add(new StiPushTranslateTransformGeom(x, y));
    }

    public void PushRotateTransform(float angle) {
        this.geoms.add(new StiPushRotateTransformGeom(angle));
    }

    public void PopTransform() {
        this.geoms.add(new StiPopTransformGeom());
    }

    public void PushClip(StiRectangle clipRect) {
        this.geoms.add(new StiPushClipGeom(clipRect));
    }

    public void PopClip() {
        this.geoms.add(new StiPopClipGeom());
    }

    public void DrawAnimationColumn(Object brush, StiPenGeom borderPen, Object rect, Double value, String toolTip, Object tag, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiClusteredColumnSeriesAnimationGeom(brush, borderPen, rect, value, toolTip, tag, animation, interaction));
    }

    public void DrawAnimationBar(Object brush, StiPenGeom borderPen, Object columnRect, Double value, String toolTip, Object tag, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiClusteredBarSeriesAnimationGeom(brush, borderPen, columnRect, value, toolTip, tag, animation, interaction));
    }

    public void DrawAnimationRectangle(Object brush, StiPenGeom pen, StiRectangle rect, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiBorderAnimationGeom(brush, pen, rect, animation, interaction));
    }

    public void DrawAnimationPathElement(Object brush, StiPenGeom borderPen, List<StiSegmentGeom> path, Object rect, String toolTip, Object tag, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiPathElementAnimationGeom(brush, borderPen, path, rect, toolTip, tag, animation, interaction));
    }

    public void DrawAnimationLabel(String text, StiFontGeom font, Object textBrush, Object labelBrush, StiPenGeom penBorder, StiRectangle rect, StiStringFormatGeom sf, StiRotationMode mode, float angle, Boolean drawBorder, StiAnimation animation) {
        this.geoms.add(new StiLabelAnimationGeom(text, font, textBrush, labelBrush, penBorder, rect, sf, mode, angle, drawBorder, animation));
    }

    public void DrawAnimationLines(StiPenGeom pen, StiPoint[] points, StiAnimation animation) {
        this.geoms.add(new StiLinesAnimationGeom(pen, points, animation));
    }

    public void DrawAnimationCurve(StiPenGeom pen, StiPoint[] points, float tension, StiAnimation animation) {
        this.geoms.add(new StiCurveAnimationGeom(pen, points, tension, animation));
    }

    public void FillDrawAnimationPath(Object brush, StiPenGeom pen, List<StiSegmentGeom> path, Object rect, Object tag, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiPathAnimationGeom(brush, pen, path, rect, tag, animation, interaction));
    }

    public void FillDrawAnimationEllipse(Object brush, StiPenGeom pen, double x, double y, double width, double height, String toolTip, Object tag, StiAnimation animation, StiInteractionDataGeom interaction) {
        this.geoms.add(new StiEllipseAnimationGeom(brush, pen, new StiRectangle(x, y, width, height), toolTip, tag, animation, interaction));
    }

    public void DrawLine(StiPenGeom pen, double x1, double y1, double x2, double y2) {
        this.geoms.add(new StiLineGeom(pen, x1, y1, x2, y2));
    }

    public void DrawLines(StiPenGeom pen, StiPoint[] points, boolean useZoom) {
        for (int index = 0; index < points.length; ++index) {
            StiPoint pos = points[index];
            if (Double.isNaN(pos.x)) {
                pos.x = 0.0;
            }
            if (Double.isNaN(pos.y)) {
                pos.y = 0.0;
            }
            points[index] = pos;
        }
        this.geoms.add(new StiLinesGeom(pen, points, useZoom));
    }

    public void DrawLines(StiPenGeom pen, StiPoint[] points) {
        this.DrawLines(pen, points, false);
    }

    public void DrawRectangle(StiPenGeom pen, StiRectangle rect) {
        this.geoms.add(new StiBorderGeom(null, pen, rect));
    }

    public void DrawRectangle(StiPenGeom pen, double x, double y, double width, double height) {
        this.geoms.add(new StiBorderGeom(null, pen, new StiRectangle(x, y, width, height)));
    }

    public void DrawEllipse(StiPenGeom pen, double x, double y, double width, double height) {
        this.geoms.add(new StiEllipseGeom(null, pen, new StiRectangle(x, y, width, height)));
    }

    public void DrawEllipse(StiPenGeom pen, StiRectangle rect) {
        this.geoms.add(new StiEllipseGeom(null, pen, rect));
    }

    public void FillEllipse(Object brush, double x, double y, double width, double height) {
        this.geoms.add(new StiEllipseGeom(brush, null, new StiRectangle(x, y, width, height)));
    }

    public void FillEllipse(Object brush, StiRectangle rect) {
        this.geoms.add(new StiEllipseGeom(brush, null, rect));
    }

    public void DrawPath(StiPenGeom pen, List<StiSegmentGeom> path, Object rect) {
        this.DrawPath(pen, path, rect, false);
    }

    public void DrawPath(StiPenGeom pen, List<StiSegmentGeom> path, Object rect, boolean useZoom) {
        this.geoms.add(new StiPathGeom(null, pen, path, rect));
    }

    public void FillPath(Object brush, List<StiSegmentGeom> path, Object rect) {
        this.geoms.add(new StiPathGeom(brush, null, path, rect));
    }

    public void DrawCurve(StiPenGeom pen, StiPoint[] points, float tension) {
        this.geoms.add(new StiCurveGeom(pen, points, tension));
    }

    public void FillRectangle(Object brush, StiRectangle rect) {
        this.geoms.add(new StiBorderGeom(brush, null, rect));
    }

    public void FillRectangle(Object brush, double x, double y, double width, double height) {
        this.geoms.add(new StiBorderGeom(brush, null, new StiRectangle(x, y, width, height)));
    }

    public void PushSmoothingModeToAntiAlias() {
        this.geoms.add(new StiPushSmothingModeToAntiAliasGeom());
    }

    public void PopSmoothingMode() {
        this.geoms.add(new StiPopSmothingModeGeom());
    }

    public void PushTextRenderingHintToAntiAlias() {
        this.geoms.add(new StiPushTextRenderingHintToAntiAliasGeom());
    }

    public void PopTextRenderingHint() {
        this.geoms.add(new StiPopTextRenderingHintGeom());
    }

    public StiRectangle GetPathBounds(List<StiSegmentGeom> geoms) {
        return this.contextPainter.getPathBounds(geoms);
    }

    public IStiContextPainter getContextPainter() {
        return this.contextPainter;
    }

    public List<StiGeom> getGeoms() {
        return this.geoms;
    }

    public void DrawShadowRect(StiRectangle rect, int shadowWidth, StiAnimation animation) {
        this.geoms.add(new StiShadowAnimationGeom(rect, shadowWidth, animation));
    }

    public void DrawShadowRect(StiRectangle rect, double radiusX, double radiusY, int shadowWidth, StiAnimation animation) {
        this.geoms.add(new StiShadowAnimationGeom(rect, radiusX, radiusY, shadowWidth, animation));
    }
}

