/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiLineInfo;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class MeasureString {
    private final String allText;
    private final Font font;
    private final boolean underline;
    private final boolean wordWrap;
    private final List<StiLineInfo> lines = new ArrayList<StiLineInfo>();
    private final Graphics2D graphics;
    private final double maxWidth;
    private StiSize size;
    private String lastText;

    public MeasureString(String allText, StiFont stiFont, float maxWidth) {
        this(allText, MeasureString.createAnalogueSwingFont(stiFont), maxWidth, false, true, false);
    }

    public MeasureString(String allText, StiFont stiFont) {
        this(allText, MeasureString.createAnalogueSwingFont(stiFont), 0.0, false, false, false);
    }

    public MeasureString(String allText, Font awtFont, float maxWidth) {
        this(allText, awtFont, maxWidth, false, true, false);
    }

    public MeasureString(String allText, Font awtFont, double maxWidth, Boolean underline, Boolean wordWrap, boolean addLineBreak) {
        this.allText = allText;
        this.font = awtFont;
        this.underline = underline;
        this.wordWrap = wordWrap;
        this.graphics = MeasureString.getGraphics();
        this.maxWidth = maxWidth >= 0.0 ? maxWidth : 0.0;
        this.calculation(addLineBreak);
    }

    private static Graphics2D getGraphics() {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        return (Graphics2D)bi.getGraphics();
    }

    public void calculation(boolean addLineBreak) {
        if (StiValidationUtil.isEmpty((String)this.allText)) {
            this.size = StiSize.getEmpty();
        } else {
            StringTokenizer paragraphTokenizer = new StringTokenizer(this.allText, "\n", true);
            while (paragraphTokenizer.hasMoreElements()) {
                String textParagraph = paragraphTokenizer.nextToken();
                this.processingParagraph(textParagraph, addLineBreak);
            }
            this.size = this.getTextMeasure();
        }
    }

    private void processingParagraph(String textParagraph, boolean addLineBreak) {
        if (this.notValidText(textParagraph, addLineBreak)) {
            this.lastText = textParagraph;
            return;
        }
        this.lastText = textParagraph;
        AttributedString attributedString = new AttributedString(textParagraph);
        attributedString.addAttribute(TextAttribute.FONT, this.font);
        if (this.underline) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.wordWrap) {
            this.wordWrap(textParagraph, attributedString);
        } else {
            this.notWordWrap(textParagraph, attributedString);
        }
    }

    private boolean notValidText(String text, boolean addLineBreak) {
        if (addLineBreak && this.lines.size() > 0 && text.equals("\n")) {
            this.lines.get(this.lines.size() - 1).setText(this.lines.get(this.lines.size() - 1).getText() + "\n");
        }
        if (this.lastText == null) {
            return text.equals("\n");
        }
        return text.equals("\n") && !this.lastText.equals("\n");
    }

    private StiSize getTextMeasure() {
        if (this.lines.size() == 0) {
            return new StiSize(0, 0);
        }
        double width = this.lines.get(0).getWidth();
        for (StiLineInfo line : this.lines) {
            width = Math.max(width, line.getWidth());
        }
        double height = this.lines.get(0).getHeight() * (double)this.lines.size();
        return new StiSize(width, height);
    }

    private void wordWrap(String text, AttributedString attributedString) {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.graphics.getFontRenderContext());
        int charPos = 0;
        int endIndex = attributedCharacterIterator.getEndIndex();
        while (lineBreakMeasurer.getPosition() < endIndex) {
            lineBreakMeasurer.nextLayout((float)this.maxWidth);
            String lineText = text.substring(charPos, lineBreakMeasurer.getPosition());
            StiSize size = this.getFontMetrics(lineText);
            this.lines.add(new StiLineInfo(lineText, size.getWidth(), size.getHeight()));
            charPos = lineBreakMeasurer.getPosition();
        }
    }

    private void notWordWrap(String text, AttributedString attributedString) {
        StiSize size = this.getFontMetrics(text);
        this.lines.add(new StiLineInfo(text, size.getWidth(), size.getHeight()));
    }

    public StiSize getFontMetrics(String text) {
        FontMetrics fm = this.graphics.getFontMetrics(this.font);
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        double widthNet = width + this.coefficientForSmallWidth(width);
        StiSize size = new StiSize(widthNet, (double)height);
        return size;
    }

    private int coefficientForSmallWidth(int width) {
        return this.font.getSize() - 5;
    }

    public List<StiLineInfo> getLines() {
        return this.lines;
    }

    protected static Font createAnalogueSwingFont(StiFont stiFont) {
        double sizePts = stiFont.getSize() * 1.32;
        int sizeInt = (int)Math.round(sizePts + 0.5);
        Font font = new Font(stiFont.getName(), stiFont.getFontStyle(), sizeInt);
        return font;
    }

    public StiSize getSize() {
        return this.size;
    }
}

